/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.naming;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MetadataNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    private static final char[] QUOTABLE_CHARS = new char[]{',', '=', ':', '\"'};
    private @Nullable JmxAttributeSource attributeSource;
    private @Nullable String defaultDomain;

    public MetadataNamingStrategy() {
    }

    public MetadataNamingStrategy(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, (String)"JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("Property 'attributeSource' is required");
        }
    }

    @Override
    public ObjectName getObjectName(Object managedBean, @Nullable String beanKey) throws MalformedObjectNameException {
        Assert.state((this.attributeSource != null ? 1 : 0) != 0, (String)"No JmxAttributeSource set");
        Class managedClass = AopUtils.getTargetClass((Object)managedBean);
        ManagedResource mr = this.attributeSource.getManagedResource(managedClass);
        if (mr != null && StringUtils.hasText((String)mr.getObjectName())) {
            return ObjectNameManager.getInstance(mr.getObjectName());
        }
        Assert.state((beanKey != null ? 1 : 0) != 0, (String)"No ManagedResource attribute and no bean key specified");
        try {
            return ObjectNameManager.getInstance(beanKey);
        }
        catch (MalformedObjectNameException ex) {
            String domain = this.defaultDomain;
            if (domain == null) {
                domain = ClassUtils.getPackageName((Class)managedClass);
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("type", ClassUtils.getShortName((Class)managedClass));
            properties.put("name", MetadataNamingStrategy.quoteIfNecessary(beanKey));
            return ObjectNameManager.getInstance(domain, properties);
        }
    }

    private static String quoteIfNecessary(String value) {
        return MetadataNamingStrategy.shouldQuote(value) ? ObjectName.quote(value) : value;
    }

    private static boolean shouldQuote(String value) {
        for (char quotableChar : QUOTABLE_CHARS) {
            if (value.indexOf(quotableChar) == -1) continue;
            return true;
        }
        return false;
    }
}

