/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public abstract class ResourceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String readFileFromClasspath(String url) {
        ClassPathResource classPathResource = new ClassPathResource(url);
        try (InputStream is = classPathResource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)is, (Charset)Charset.defaultCharset());
            return string;
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to load file from url: %s: %s", url, e.getMessage()));
            return null;
        }
    }

    private ResourceUtil() {
    }
}

