/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.config.server.ssh.SshUriProperties;

public abstract class SshUri {
    private String privateKey;
    private String uri;
    private String hostKeyAlgorithm;
    private String hostKey;
    private boolean ignoreLocalSshSettings;
    private boolean strictHostKeyChecking = true;

    public static SshUriPropertiesBuilder builder() {
        return new SshUriPropertiesBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getHostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isIgnoreLocalSshSettings() {
        return this.ignoreLocalSshSettings;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setIgnoreLocalSshSettings(boolean ignoreLocalSshSettings) {
        this.ignoreLocalSshSettings = ignoreLocalSshSettings;
    }

    public void setStrictHostKeyChecking(boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public String toString() {
        return "org.springframework.cloud.config.server.ssh.SshUriProperties(uri=" + this.getUri() + " hostKeyAlgorithm=" + this.getHostKeyAlgorithm() + ", hostKey=" + this.getHostKey() + ", privateKey=" + this.getPrivateKey() + ", ignoreLocalSshSettings=" + this.isIgnoreLocalSshSettings() + ", strictHostKeyChecking=" + this.isStrictHostKeyChecking() + ",)";
    }

    public static class SshUriPropertiesBuilder {
        private String uri;
        private String hostKeyAlgorithm;
        private String hostKey;
        private String privateKey;
        private boolean ignoreLocalSshSettings;
        private boolean strictHostKeyChecking = true;
        private Map<String, SshUriProperties.SshUriNestedRepoProperties> repos = new LinkedHashMap<String, SshUriProperties.SshUriNestedRepoProperties>();

        SshUriPropertiesBuilder() {
        }

        public SshUriPropertiesBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public SshUriPropertiesBuilder hostKeyAlgorithm(String hostKeyAlgorithm) {
            this.hostKeyAlgorithm = hostKeyAlgorithm;
            return this;
        }

        public SshUriPropertiesBuilder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public SshUriPropertiesBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public SshUriPropertiesBuilder ignoreLocalSshSettings(boolean ignoreLocalSshSettings) {
            this.ignoreLocalSshSettings = ignoreLocalSshSettings;
            return this;
        }

        public SshUriPropertiesBuilder strictHostKeyChecking(boolean strictHostKeyChecking) {
            this.strictHostKeyChecking = strictHostKeyChecking;
            return this;
        }

        public SshUriPropertiesBuilder repos(Map<String, SshUriProperties.SshUriNestedRepoProperties> repos) {
            this.repos = repos;
            return this;
        }

        public SshUriProperties build() {
            SshUriProperties sshUriProperties = new SshUriProperties();
            sshUriProperties.setRepos(this.repos);
            this.build(sshUriProperties);
            return sshUriProperties;
        }

        public SshUriProperties.SshUriNestedRepoProperties buildAsNestedRepo() {
            SshUriProperties.SshUriNestedRepoProperties sshUriNestedRepoProperties = new SshUriProperties.SshUriNestedRepoProperties();
            this.build(sshUriNestedRepoProperties);
            return sshUriNestedRepoProperties;
        }

        private void build(SshUri sshUriNestedRepoProperties) {
            sshUriNestedRepoProperties.setUri(this.uri);
            sshUriNestedRepoProperties.setHostKeyAlgorithm(this.hostKeyAlgorithm);
            sshUriNestedRepoProperties.setHostKey(this.hostKey);
            sshUriNestedRepoProperties.setPrivateKey(this.privateKey);
            sshUriNestedRepoProperties.setIgnoreLocalSshSettings(this.ignoreLocalSshSettings);
            sshUriNestedRepoProperties.setStrictHostKeyChecking(this.strictHostKeyChecking);
        }

        public String toString() {
            return "org.springframework.cloud.config.server.ssh.SshUriProperties.SshUriPropertiesBuilder(uri=" + this.uri + "hostKeyAlgorithm=" + this.hostKeyAlgorithm + ", hostKey=" + this.hostKey + ", privateKey=" + this.privateKey + ", ignoreLocalSshSettings=" + this.ignoreLocalSshSettings + ", strictHostKeyChecking=" + this.strictHostKeyChecking + ", repos=" + this.repos + ")";
        }
    }
}

