/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springaicommunity.qianfan.QianFanEmbeddingModel;
import org.springaicommunity.qianfan.api.QianFanApi;
import org.springaicommunity.qianfan.autoconfigure.QianFanConnectionProperties;
import org.springaicommunity.qianfan.autoconfigure.QianFanEmbeddingProperties;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={QianFanApi.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding"}, havingValue="qianfan", matchIfMissing=true)
@EnableConfigurationProperties(value={QianFanConnectionProperties.class, QianFanEmbeddingProperties.class})
public class QianFanEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public QianFanEmbeddingModel qianFanEmbeddingModel(QianFanConnectionProperties commonProperties, QianFanEmbeddingProperties embeddingProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        QianFanApi qianFanApi = this.qianFanApi(embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), embeddingProperties.getApiKey(), commonProperties.getApiKey(), embeddingProperties.getSecretKey(), commonProperties.getSecretKey(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanEmbeddingModel embeddingModel = new QianFanEmbeddingModel(qianFanApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    private QianFanApi qianFanApi(String baseUrl, String commonBaseUrl, String apiKey, String commonApiKey, String secretKey, String commonSecretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedBaseUrl, (String)"QianFan base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        Assert.hasText((String)resolvedApiKey, (String)"QianFan API key must be set");
        String resolvedSecretKey = StringUtils.hasText((String)secretKey) ? secretKey : commonSecretKey;
        Assert.hasText((String)resolvedSecretKey, (String)"QianFan Secret key must be set");
        return new QianFanApi(resolvedBaseUrl, resolvedApiKey, resolvedSecretKey, restClientBuilder, responseErrorHandler);
    }
}

