/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springaicommunity.qianfan.QianFanChatModel;
import org.springaicommunity.qianfan.api.QianFanApi;
import org.springaicommunity.qianfan.autoconfigure.QianFanChatProperties;
import org.springaicommunity.qianfan.autoconfigure.QianFanConnectionProperties;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={QianFanApi.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="qianfan", matchIfMissing=true)
@EnableConfigurationProperties(value={QianFanConnectionProperties.class, QianFanChatProperties.class})
public class QianFanChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public QianFanChatModel qianFanChatModel(QianFanConnectionProperties commonProperties, QianFanChatProperties chatProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        QianFanApi qianFanApi = this.qianFanApi(chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), chatProperties.getApiKey(), commonProperties.getApiKey(), chatProperties.getSecretKey(), commonProperties.getSecretKey(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanChatModel chatModel = new QianFanChatModel(qianFanApi, chatProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    private QianFanApi qianFanApi(String baseUrl, String commonBaseUrl, String apiKey, String commonApiKey, String secretKey, String commonSecretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedBaseUrl, (String)"QianFan base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        Assert.hasText((String)resolvedApiKey, (String)"QianFan API key must be set");
        String resolvedSecretKey = StringUtils.hasText((String)secretKey) ? secretKey : commonSecretKey;
        Assert.hasText((String)resolvedSecretKey, (String)"QianFan Secret key must be set");
        return new QianFanApi(resolvedBaseUrl, resolvedApiKey, resolvedSecretKey, restClientBuilder, responseErrorHandler);
    }
}

