/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.elicitation;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springaicommunity.mcp.method.elicitation.AbstractMcpElicitationMethodCallback;

public final class SyncMcpElicitationMethodCallback
extends AbstractMcpElicitationMethodCallback
implements Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> {
    private SyncMcpElicitationMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public McpSchema.ElicitResult apply(McpSchema.ElicitRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, request);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            return (McpSchema.ElicitResult)result;
        }
        catch (Exception e) {
            throw new AbstractMcpElicitationMethodCallback.McpElicitationMethodException("Error invoking elicitation method: " + this.method.getName(), e);
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!McpSchema.ElicitResult.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must return ElicitResult: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeType(Class<?> paramType) {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpElicitationMethodCallback.AbstractBuilder<Builder, SyncMcpElicitationMethodCallback> {
        @Override
        public SyncMcpElicitationMethodCallback build() {
            this.validate();
            return new SyncMcpElicitationMethodCallback(this);
        }
    }
}

