/*
 * Decompiled with CFR 0.152.
 */
package org.phprpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.phprpc.RemoteFunction;
import org.phprpc.util.Base64;
import org.phprpc.util.Cast;
import org.phprpc.util.DHParams;
import org.phprpc.util.PHPSerializer;
import org.phprpc.util.XXTEA;

public final class PHPRPC_Server {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private PHPSerializer phpser = new PHPSerializer();
    private HashMap functions = new HashMap();
    private boolean debug = false;
    private String charset = "UTF-8";
    private boolean encode;
    private boolean byref;
    private boolean encrypt;
    private boolean enableGZIP = false;
    private int encryptMode;
    private byte[] key;
    private int keylen;
    private BigInteger y;
    private String output;
    private String callback;
    private int errno;
    private String errstr;
    private String cid;
    private StringBuffer buffer;
    private static HashMap globalFunctions = new HashMap();

    private static boolean add(String[] funcnames, Object obj, Class cls, String[] aliases, HashMap functions) {
        if (aliases == null) {
            aliases = funcnames;
        }
        if (funcnames.length != aliases.length) {
            return false;
        }
        Method[] methods = cls.getMethods();
        int n = funcnames.length;
        for (int i = 0; i < n; ++i) {
            ArrayList<Method> fs = new ArrayList<Method>();
            int m = methods.length;
            for (int j = 0; j < m; ++j) {
                int mod = methods[j].getModifiers();
                if (!funcnames[i].toLowerCase().equals(methods[j].getName().toLowerCase()) || !Modifier.isPublic(mod) || obj == null != Modifier.isStatic(mod)) continue;
                fs.add(methods[j]);
            }
            if (fs.size() <= 0) continue;
            functions.put(aliases[i].toLowerCase(), new RemoteFunction(obj, fs.toArray(new Method[fs.size()])));
        }
        return true;
    }

    private static boolean add(Method[] funcs, Object obj, String[] aliases, HashMap functions) {
        int i;
        if (aliases == null) {
            aliases = new String[funcs.length];
            for (i = 0; i < funcs.length; ++i) {
                aliases[i] = funcs[i].getName();
            }
        }
        if (funcs.length != aliases.length) {
            return false;
        }
        for (i = 0; i < funcs.length; ++i) {
            int mod = funcs[i].getModifiers();
            if (!Modifier.isPublic(mod) || obj == null != Modifier.isStatic(mod)) continue;
            functions.put(aliases[i].toLowerCase(), new RemoteFunction(obj, new Method[]{funcs[i]}));
        }
        return true;
    }

    public static String[] getAllFunctions(Class cls) {
        Method[] methods = cls.getDeclaredMethods();
        HashMap<String, String> names = new HashMap<String, String>();
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers())) continue;
            String fn = methods[i].getName().toLowerCase();
            names.put(fn, fn);
        }
        Object[] fo = names.keySet().toArray();
        String[] fs = new String[fo.length];
        System.arraycopy(fo, 0, fs, 0, fo.length);
        return fs;
    }

    private String toHexString(int n) {
        return (n < 16 ? "0" : "") + Integer.toHexString(n);
    }

    private String addJsSlashes(String str) {
        char[] s = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (s[i] <= '\u001f' || s[i] == '\"' || s[i] == '\'' || s[i] == '\\' || s[i] == '\u007f') {
                sb.append("\\x");
                sb.append(this.toHexString(s[i] & 0xFF));
                continue;
            }
            sb.append(s[i]);
        }
        return sb.toString();
    }

    private String addJsSlashes(byte[] s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (s[i] <= 31 || s[i] == 34 || s[i] == 39 || s[i] == 92 || s[i] >= 127) {
                sb.append("\\x");
                sb.append(this.toHexString(s[i] & 0xFF));
                continue;
            }
            sb.append((char)s[i]);
        }
        return sb.toString();
    }

    private String encodeString(String s) throws UnsupportedEncodingException {
        if (this.encode) {
            return Base64.encode(s.getBytes(this.charset));
        }
        return this.addJsSlashes(s);
    }

    private String encodeString(byte[] s) {
        if (this.encode) {
            return Base64.encode(s);
        }
        return this.addJsSlashes(s);
    }

    private byte[] encryptString(byte[] s, int level) {
        if (this.encryptMode >= level) {
            s = XXTEA.encrypt(s, this.key);
        }
        return s;
    }

    private byte[] decryptString(byte[] s, int level) {
        if (this.encryptMode >= level) {
            s = XXTEA.decrypt(s, this.key);
        }
        return s;
    }

    private void sendURL() throws UnsupportedEncodingException {
        if (!this.request.isRequestedSessionIdValid() || this.session.isNew()) {
            StringBuffer url = this.request.getRequestURL();
            Enumeration e = this.request.getParameterNames();
            if (e.hasMoreElements()) {
                url.append('?');
                do {
                    String query;
                    if ((query = (String)e.nextElement()).toLowerCase().startsWith("phprpc_")) continue;
                    String[] values = this.request.getParameterValues(query);
                    int n = values.length;
                    for (int i = 0; i < n; ++i) {
                        url.append(query).append('=').append(URLEncoder.encode(values[i], this.charset)).append('&');
                    }
                } while (e.hasMoreElements());
                url.setLength(url.length() - 1);
            }
            this.buffer.append("phprpc_url=\"");
            this.buffer.append(this.encodeString(this.response.encodeURL(url.toString())));
            this.buffer.append("\";\r\n");
        }
    }

    private void gzip(byte[] s) throws IOException {
        String acceptEncoding = this.request.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            GZIPOutputStream gzips = new GZIPOutputStream(bs);
            gzips.write(s);
            gzips.finish();
            if (s.length > bs.size()) {
                this.response.setHeader("Content-Encoding", "gzip");
                this.response.setContentLength(bs.size());
                bs.writeTo((OutputStream)this.response.getOutputStream());
                return;
            }
        }
        this.response.setContentLength(s.length);
        this.response.getOutputStream().write(s);
    }

    private void sendCallback() throws IOException {
        this.buffer.append(this.callback);
        String buf = this.buffer.toString();
        if (this.enableGZIP) {
            this.gzip(buf.getBytes(this.charset));
        } else {
            this.response.getWriter().write(buf);
        }
        this.response.flushBuffer();
    }

    private void sendFunctions() throws IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.buffer.append("phprpc_functions=\"");
        this.functions.putAll(globalFunctions);
        this.buffer.append(this.encodeString(this.phpser.serialize(this.functions.keySet().toArray())));
        this.buffer.append("\";\r\n");
        this.sendCallback();
    }

    private void sendOutput() throws IOException {
        if (this.encryptMode >= 3) {
            this.buffer.append("phprpc_output=\"");
            this.buffer.append(this.encodeString(XXTEA.encrypt(this.output.getBytes(this.charset), this.key)));
            this.buffer.append("\";\r\n");
        } else {
            this.buffer.append("phprpc_output=\"");
            this.buffer.append(this.encodeString(this.output));
            this.buffer.append("\";\r\n");
        }
    }

    private void sendError() throws IOException {
        this.buffer.append("phprpc_errno=\"");
        this.buffer.append(this.errno);
        this.buffer.append("\";\r\n");
        this.buffer.append("phprpc_errstr=\"");
        this.buffer.append(this.encodeString(this.errstr));
        this.buffer.append("\";\r\n");
        this.sendOutput();
        this.sendCallback();
    }

    private void sendHeader() {
        this.response.setContentType("text/plain; charset=" + this.charset);
        this.response.setHeader("P3P", "CP=\"CAO DSP COR CUR ADM DEV TAI PSA PSD IVAi IVDi CONi TELo OTPi OUR DELi SAMi OTRi UNRi PUBi IND PHY ONL UNI PUR FIN COM NAV INT DEM CNT STA POL HEA PRE GOV\"");
        this.response.setHeader("X-Powered-By", "PHPRPC Server/3.0");
        this.response.setDateHeader("Expires", new Date().getTime());
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] call(Method function, Object obj, ArrayList arguments) throws Throwable {
        Class<?>[] p = function.getParameterTypes();
        String funcname = function.getName();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bs, false, this.charset);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)bs, this.charset), false);
        int size = arguments.size();
        if (p.length != size) {
            if (this.session == null) {
                this.session = this.request.getSession(true);
            }
            if (p.length == size + 1) {
                String className = p[p.length - 1].getName();
                if (className.equals("javax.servlet.http.HttpServletRequest")) {
                    arguments.add(this.request);
                } else if (className.equals("javax.servlet.http.HttpSession")) {
                    arguments.add(this.session);
                } else if (className.equals("javax.servlet.ServletContext")) {
                    arguments.add(this.session.getServletContext());
                } else if (className.equals("java.io.PrintStream")) {
                    arguments.add(ps);
                } else {
                    if (!className.equals("java.io.PrintWriter")) throw new IllegalArgumentException("number of arguments mismatch for " + funcname + "().");
                    arguments.add(pw);
                }
            } else {
                if (p.length != size + 2) throw new IllegalArgumentException("number of arguments mismatch for " + funcname + "().");
                String className1 = p[p.length - 2].getName();
                String className2 = p[p.length - 1].getName();
                if (className1.equals("javax.servlet.http.HttpServletRequest") && className2.equals("java.io.PrintStream")) {
                    arguments.add(this.request);
                    arguments.add(ps);
                } else if (className1.equals("javax.servlet.http.HttpServletRequest") && className2.equals("java.io.PrintWriter")) {
                    arguments.add(this.request);
                    arguments.add(pw);
                } else if (className1.equals("java.io.PrintStream") && className2.equals("javax.servlet.http.HttpServletRequest")) {
                    arguments.add(ps);
                    arguments.add(this.request);
                } else if (className1.equals("java.io.PrintWriter") && className2.equals("javax.servlet.http.HttpServletRequest")) {
                    arguments.add(pw);
                    arguments.add(this.request);
                } else if (className1.equals("javax.servlet.http.HttpSession") && className2.equals("java.io.PrintStream")) {
                    arguments.add(this.session);
                    arguments.add(ps);
                } else if (className1.equals("javax.servlet.http.HttpSession") && className2.equals("java.io.PrintWriter")) {
                    arguments.add(this.session);
                    arguments.add(pw);
                } else if (className1.equals("java.io.PrintStream") && className2.equals("javax.servlet.http.HttpSession")) {
                    arguments.add(ps);
                    arguments.add(this.session);
                } else if (className1.equals("java.io.PrintWriter") && className2.equals("javax.servlet.http.HttpSession")) {
                    arguments.add(pw);
                    arguments.add(this.session);
                } else if (className1.equals("javax.servlet.ServletContext") && className2.equals("java.io.PrintStream")) {
                    arguments.add(this.session.getServletContext());
                    arguments.add(ps);
                } else if (className1.equals("javax.servlet.ServletContext") && className2.equals("java.io.PrintWriter")) {
                    arguments.add(this.session.getServletContext());
                    arguments.add(pw);
                } else if (className1.equals("java.io.PrintStream") && className2.equals("javax.servlet.ServletContext")) {
                    arguments.add(ps);
                    arguments.add(this.session.getServletContext());
                } else {
                    if (!className1.equals("java.io.PrintWriter") || !className2.equals("javax.servlet.ServletContext")) throw new IllegalArgumentException("number of arguments mismatch for " + funcname + "().");
                    arguments.add(pw);
                    arguments.add(this.session.getServletContext());
                }
            }
        }
        Object[] args = arguments.toArray();
        while (size < arguments.size()) {
            arguments.remove(size);
        }
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (args[i] == null) continue;
            args[i] = Cast.cast(args[i], p[i], this.charset);
        }
        byte[] result = null;
        try {
            result = this.phpser.serialize(function.invoke(obj, args));
        }
        catch (IllegalAccessException e1) {
            throw new IllegalArgumentException(e1.getMessage() + " for " + funcname + "().");
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException(e2.getMessage() + " for " + funcname + "().");
        }
        catch (NullPointerException e3) {
            throw new NullPointerException(e3.getMessage() + " for " + funcname + "().");
        }
        catch (ExceptionInInitializerError e4) {
            Throwable e5 = e4.getCause();
            if (e5 == null) throw new ExceptionInInitializerError(e4.getMessage() + " for " + funcname + "().");
            throw e5;
        }
        catch (InvocationTargetException e6) {
            Throwable e7 = e6.getCause();
            if (e7 == null) throw new InvocationTargetException(null, e6.getMessage() + " for " + funcname + "().");
            throw e7;
        }
        ps.close();
        pw.close();
        this.output = new String(bs.toByteArray(), this.charset);
        return result;
    }

    private boolean getBooleanRequest(String name) {
        boolean var = true;
        if (this.request.getParameter(name) != null && this.request.getParameter(name).toLowerCase().equals("false")) {
            var = false;
        }
        return var;
    }

    private void initEncode() {
        this.encode = this.getBooleanRequest("phprpc_encode");
    }

    private void initRef() {
        this.byref = this.getBooleanRequest("phprpc_ref");
    }

    private void initErrorHandler() {
        this.errno = 0;
        this.errstr = "";
        this.output = "";
    }

    private void initCallback() throws UnsupportedEncodingException {
        this.callback = this.request.getParameter("phprpc_callback") != null ? new String(Base64.decode(this.request.getParameter("phprpc_callback")), this.charset) : "";
    }

    private void initClientID() {
        this.cid = "0";
        if (this.request.getParameter("phprpc_id") != null) {
            this.cid = this.request.getParameter("phprpc_id");
        }
        this.cid = "phprpc_" + this.cid;
    }

    private void initKeylen() {
        HashMap sessionObject;
        this.keylen = this.request.getParameter("phprpc_keylen") != null ? Integer.parseInt(this.request.getParameter("phprpc_keylen")) : ((sessionObject = (HashMap)this.session.getAttribute(this.cid)) != null && sessionObject.get("keylen") != null ? (Integer)sessionObject.get("keylen") : 128);
    }

    private void initEncrypt() {
        this.encrypt = false;
        this.encryptMode = 0;
        this.y = null;
        if (this.request.getParameter("phprpc_encrypt") != null) {
            String enc = this.request.getParameter("phprpc_encrypt").toLowerCase();
            if (enc.equals("true")) {
                this.encrypt = true;
            } else if (enc.equals("false")) {
                this.encrypt = false;
            } else if (enc.equals("0")) {
                this.encryptMode = 0;
            } else if (enc.equals("1")) {
                this.encryptMode = 1;
            } else if (enc.equals("2")) {
                this.encryptMode = 2;
            } else if (enc.equals("3")) {
                this.encryptMode = 3;
            } else {
                this.y = new BigInteger(enc);
            }
        }
    }

    private void initKey() throws Exception {
        if (this.encryptMode > 0) {
            HashMap sessionObject;
            if (this.session == null) {
                this.session = this.request.getSession(true);
            }
            if ((sessionObject = (HashMap)this.session.getAttribute(this.cid)) != null && sessionObject.get("key") != null) {
                this.key = (byte[])sessionObject.get("key");
            } else {
                this.encryptMode = 0;
                throw new Exception("Can't find the key for decryption.");
            }
        }
    }

    private ArrayList getArguments() throws UnsupportedEncodingException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList arguments = this.request.getParameter("phprpc_args") != null ? (ArrayList)this.phpser.unserialize(this.decryptString(Base64.decode(this.request.getParameter("phprpc_args")), 1), ArrayList.class) : new ArrayList();
        return arguments;
    }

    private void callFunction() throws Throwable {
        String funcname = this.request.getParameter("phprpc_func").toLowerCase();
        RemoteFunction rf = null;
        if (this.functions.containsKey(funcname)) {
            rf = (RemoteFunction)this.functions.get(funcname);
        } else if (globalFunctions.containsKey(funcname)) {
            rf = (RemoteFunction)globalFunctions.get(funcname);
        } else {
            throw new NoSuchMethodException("Can't find this function " + this.request.getParameter("phprpc_func") + "().");
        }
        this.initKey();
        ArrayList arguments = this.getArguments();
        String result = null;
        int n = rf.functions.length;
        for (int i = 0; i < n; ++i) {
            try {
                result = this.encodeString(this.encryptString(this.call(rf.functions[i], rf.obj, arguments), 2));
                break;
            }
            catch (Throwable e) {
                if (i == n - 1) {
                    this.errstr = "";
                    throw e;
                }
                this.errno = 2;
                if (this.debug) {
                    StackTraceElement[] st = e.getStackTrace();
                    StringBuffer es = new StringBuffer(e.toString()).append("\r\n");
                    int m = st.length;
                    for (int j = 0; j < m; ++j) {
                        es.append(st[j].toString()).append("\r\n");
                    }
                    this.errstr = this.errstr + es.toString();
                    continue;
                }
                this.errstr = this.errstr + e.toString();
                continue;
            }
        }
        this.buffer.append("phprpc_result=\"");
        this.buffer.append(result);
        this.buffer.append("\";\r\n");
        if (this.byref) {
            this.buffer.append("phprpc_args=\"");
            this.buffer.append(this.encodeString(this.encryptString(this.phpser.serialize(arguments), 1)));
            this.buffer.append("\";\r\n");
        }
        this.sendError();
    }

    private void keyExchange() throws IOException, IllegalAccessException, NoSuchAlgorithmException, IllegalArgumentException, InvocationTargetException {
        if (this.session == null) {
            this.session = this.request.getSession(true);
        }
        this.initKeylen();
        if (this.encrypt) {
            DHParams dhParams = new DHParams(this.keylen);
            this.keylen = dhParams.getL();
            BigInteger p = dhParams.getP();
            BigInteger g = dhParams.getG();
            BigInteger x = dhParams.getX();
            BigInteger y = g.modPow(x, p);
            HashMap<String, Number> sessionObject = new HashMap<String, Number>();
            sessionObject.put("x", x);
            sessionObject.put("p", p);
            sessionObject.put("keylen", new Integer(this.keylen));
            this.session.setAttribute(this.cid, sessionObject);
            HashMap dhp = dhParams.getDHParams();
            dhp.put("y", y.toString());
            this.buffer.append("phprpc_encrypt=\"");
            this.buffer.append(this.encodeString(this.phpser.serialize(dhp)));
            this.buffer.append("\";\r\n");
            if (this.keylen != 128) {
                this.buffer.append("phprpc_keylen=\"");
                this.buffer.append(this.keylen);
                this.buffer.append("\";\r\n");
            }
            this.sendURL();
        } else {
            byte[] tempkey;
            HashMap sessionObject = (HashMap)this.session.getAttribute(this.cid);
            BigInteger x = (BigInteger)sessionObject.get("x");
            BigInteger p = (BigInteger)sessionObject.get("p");
            BigInteger k = this.y.modPow(x, p);
            if (this.keylen == 128) {
                tempkey = k.toByteArray();
            } else {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(k.toString().getBytes());
                tempkey = md5.digest();
            }
            this.key = new byte[16];
            int n = Math.min(tempkey.length, 16);
            for (int i = 1; i <= n; ++i) {
                this.key[16 - i] = tempkey[tempkey.length - i];
            }
            sessionObject.put("key", this.key);
            sessionObject.remove("x");
            sessionObject.remove("p");
            this.session.setAttribute(this.cid, (Object)sessionObject);
        }
        this.sendCallback();
    }

    public static boolean addGlobal(Object obj) {
        Class<?> cls = obj.getClass();
        return PHPRPC_Server.addGlobal(PHPRPC_Server.getAllFunctions(cls), obj, cls, null);
    }

    public static boolean addGlobal(Class cls) {
        return PHPRPC_Server.addGlobal(PHPRPC_Server.getAllFunctions(cls), null, cls, null);
    }

    public static boolean addGlobal(Object obj, Class cls) {
        return PHPRPC_Server.addGlobal(PHPRPC_Server.getAllFunctions(cls), obj, cls, null);
    }

    public static boolean addGlobal(String function, Object obj) {
        return PHPRPC_Server.addGlobal(new String[]{function}, obj, obj.getClass(), null);
    }

    public static boolean addGlobal(String function, Object obj, String alias) {
        return PHPRPC_Server.addGlobal(new String[]{function}, obj, obj.getClass(), new String[]{alias});
    }

    public static boolean addGlobal(Method function, Object obj) {
        return PHPRPC_Server.addGlobal(new Method[]{function}, obj, null);
    }

    public static boolean addGlobal(Method function, Object obj, String alias) {
        return PHPRPC_Server.addGlobal(new Method[]{function}, obj, new String[]{alias});
    }

    public static boolean addGlobal(Method[] funcs, Object obj, String[] alias) {
        return PHPRPC_Server.add(funcs, obj, alias, globalFunctions);
    }

    public static boolean addGlobal(String[] functions, Object obj) {
        return PHPRPC_Server.addGlobal(functions, obj, obj.getClass(), null);
    }

    public static boolean addGlobal(String[] functions, Object obj, String[] aliases) {
        return PHPRPC_Server.addGlobal(functions, obj, obj.getClass(), aliases);
    }

    public static boolean addGlobal(String function, Class cls) {
        return PHPRPC_Server.addGlobal(new String[]{function}, null, cls, null);
    }

    public static boolean addGlobal(String function, Class cls, String alias) {
        return PHPRPC_Server.addGlobal(new String[]{function}, null, cls, new String[]{alias});
    }

    public static boolean addGlobal(String[] functions, Class cls) {
        return PHPRPC_Server.addGlobal(functions, null, cls, null);
    }

    public static boolean addGlobal(String[] functions, Class cls, String[] aliases) {
        return PHPRPC_Server.addGlobal(functions, null, cls, aliases);
    }

    public static boolean addGlobal(String function, Object obj, Class cls, String alias) {
        return PHPRPC_Server.addGlobal(new String[]{function}, obj, cls, new String[]{alias});
    }

    public static boolean addGlobal(String[] funcnames, Object obj, Class cls, String[] aliases) {
        return PHPRPC_Server.add(funcnames, obj, cls, aliases, globalFunctions);
    }

    public boolean add(Object obj) {
        Class<?> cls = obj.getClass();
        return this.add(PHPRPC_Server.getAllFunctions(cls), obj, cls, null);
    }

    public boolean add(Class cls) {
        return this.add(PHPRPC_Server.getAllFunctions(cls), null, cls, null);
    }

    public boolean add(Object obj, Class cls) {
        return this.add(PHPRPC_Server.getAllFunctions(cls), obj, cls, null);
    }

    public boolean add(String function, Object obj) {
        return this.add(new String[]{function}, obj, obj.getClass(), null);
    }

    public boolean add(String function, Object obj, String alias) {
        return this.add(new String[]{function}, obj, obj.getClass(), new String[]{alias});
    }

    public boolean add(String[] functions, Object obj) {
        return this.add(functions, obj, obj.getClass(), null);
    }

    public boolean add(String[] functions, Object obj, String[] aliases) {
        return this.add(functions, obj, obj.getClass(), aliases);
    }

    public boolean add(String function, Class cls) {
        return this.add(new String[]{function}, null, cls, null);
    }

    public boolean add(String function, Class cls, String alias) {
        return this.add(new String[]{function}, null, cls, new String[]{alias});
    }

    public boolean add(String[] functions, Class cls) {
        return this.add(functions, null, cls, null);
    }

    public boolean add(String[] functions, Class cls, String[] aliases) {
        return this.add(functions, null, cls, aliases);
    }

    public boolean add(String function, Object obj, Class cls, String alias) {
        return this.add(new String[]{function}, obj, cls, new String[]{alias});
    }

    public boolean add(String[] funcnames, Object obj, Class cls, String[] aliases) {
        return PHPRPC_Server.add(funcnames, obj, cls, aliases, this.functions);
    }

    public void setCharset(String charset) {
        this.charset = charset;
        this.phpser.setCharset(charset);
    }

    public void setDebugMode(boolean debug) {
        this.debug = debug;
    }

    public void setEnableGZIP(boolean enableGZIP) {
        this.enableGZIP = enableGZIP;
    }

    public void start(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        response.resetBuffer();
        this.session = null;
        this.buffer = new StringBuffer();
        try {
            this.initErrorHandler();
            this.sendHeader();
            this.initClientID();
            this.initEncode();
            this.initCallback();
            this.initRef();
            this.initEncrypt();
            if (request.getParameter("phprpc_func") != null) {
                this.callFunction();
            } else if (this.encrypt || this.y != null) {
                this.keyExchange();
            } else {
                this.sendFunctions();
            }
        }
        catch (Throwable e) {
            this.errno = 1;
            if (this.debug) {
                StackTraceElement[] st = e.getStackTrace();
                StringBuffer es = new StringBuffer(e.toString()).append("\r\n");
                int n = st.length;
                for (int i = 0; i < n; ++i) {
                    es.append(st[i].toString()).append("\r\n");
                }
                this.errstr = es.toString();
            } else {
                this.errstr = e.toString();
            }
            this.sendError();
        }
    }

    public String getErrstr() {
        return this.errstr;
    }
}

