/*
 * Decompiled with CFR 0.152.
 */
package org.phprpc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.phprpc.PHPRPC_Callback;
import org.phprpc.PHPRPC_Error;
import org.phprpc.PHPRPC_InvocationHandler;
import org.phprpc.SocketPool;
import org.phprpc.util.Base64;
import org.phprpc.util.Cast;
import org.phprpc.util.PHPSerializer;
import org.phprpc.util.XXTEA;

public class PHPRPC_Client {
    protected PHPSerializer __phpser = null;
    private HashMap __server = null;
    private HashMap __proxy = null;
    private int __timeout = 30000;
    private PHPRPC_Error __warning = null;
    private byte[] __key = null;
    private int __keylen = 128;
    private int __encryptMode = 0;
    private boolean __keyExchanged = false;
    private String __charset = "utf-8";
    private String __output = "";
    private SocketPool __socketPool = null;
    private boolean __keepAlive = true;
    private String __clientID = "java" + String.valueOf(new Random().nextInt()) + String.valueOf(new Date().getTime()) + String.valueOf(__sID++);
    private static int __sID = 0;
    private static String __cookie = null;
    private static final HashMap __cookies = new HashMap();

    public PHPRPC_Client() {
    }

    public PHPRPC_Client(String serverURL) {
        this();
        this.useService(serverURL);
    }

    public final Object useService(Class type) {
        PHPRPC_InvocationHandler handler = new PHPRPC_InvocationHandler(this);
        if (type.isInterface()) {
            return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        }
        return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)handler);
    }

    public final Object useService(Class[] interfaces) {
        PHPRPC_InvocationHandler handler = new PHPRPC_InvocationHandler(this);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    public final boolean useService(String serverURL) {
        return this.useService(serverURL, null, null);
    }

    public final Object useService(String serverURL, Class type) {
        if (this.useService(serverURL, null, null)) {
            return this.useService(type);
        }
        return null;
    }

    public final Object useService(String serverURL, Class[] interfaces) {
        if (this.useService(serverURL, null, null)) {
            return this.useService(interfaces);
        }
        return null;
    }

    public final boolean useService(String serverURL, String username, String password) {
        URL url;
        try {
            url = new URL(serverURL);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            return false;
        }
        this.__server = new HashMap();
        this.__server.put("scheme", url.getProtocol());
        this.__server.put("host", url.getHost());
        this.__server.put("port", new Integer(url.getPort() == -1 ? url.getDefaultPort() : url.getPort()));
        String path = url.getFile();
        path = path.indexOf(63) > -1 ? path + "&phprpc_id=" + this.__clientID : path + "?phprpc_id=" + this.__clientID;
        this.__server.put("path", path);
        this.__server.put("userinfo", username == null ? url.getUserInfo() : username + ':' + password);
        this.__socketPool = null;
        this.__keepAlive = true;
        this.__key = null;
        this.__keylen = 128;
        this.__encryptMode = 0;
        this.__keyExchanged = false;
        this.__phpser = new PHPSerializer();
        this.setCharset("utf-8");
        return true;
    }

    public final Object useService(String serverURL, String username, String password, Class type) {
        if (this.useService(serverURL, username, password)) {
            return this.useService(type);
        }
        return null;
    }

    public final Object useService(String serverURL, String username, String password, Class[] interfaces) {
        if (this.useService(serverURL, username, password)) {
            return this.useService(interfaces);
        }
        return null;
    }

    public final void setProxy(String address) throws MalformedURLException {
        if (address == null) {
            this.__proxy = null;
        } else {
            URL url = new URL(address);
            this.setProxy(url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), url.getUserInfo());
        }
    }

    public final void setProxy(String host, int port) {
        this.setProxy(host, port, null);
    }

    public final void setProxy(String host, int port, String username, String password) {
        this.setProxy(host, port, username == null ? null : username + ':' + password);
    }

    private final void setProxy(String host, int port, String userinfo) {
        this.__proxy = new HashMap();
        this.__proxy.put("host", host);
        this.__proxy.put("port", new Integer(port));
        this.__proxy.put("userinfo", userinfo);
    }

    public final boolean setKeyLength(int keyLength) {
        if (this.__key != null) {
            return false;
        }
        this.__keylen = keyLength;
        return true;
    }

    public final int getKeyLength() {
        return this.__keylen;
    }

    public final boolean setEncryptMode(int encryptMode) {
        if (encryptMode >= 0 && encryptMode <= 3) {
            this.__encryptMode = encryptMode;
            return true;
        }
        this.__encryptMode = 0;
        return false;
    }

    public final int getEncryptMode() {
        return this.__encryptMode;
    }

    public final synchronized void setCharset(String charset) {
        this.__charset = charset;
        this.__phpser.setCharset(this.__charset);
    }

    public final String getCharset() {
        return this.__charset;
    }

    public final void setTimeout(int timeout) {
        this.__timeout = timeout;
    }

    public final int getTimeout() {
        return this.__timeout;
    }

    public final String getOutput() {
        return this.__output;
    }

    public final PHPRPC_Error getWarning() {
        return this.__warning;
    }

    public final Object invoke(String function, Object[] args) {
        return this.invoke(function, args, false);
    }

    public final Object invoke(String function, Object[] args, boolean byRef) {
        HashMap response = this.invoke(function, args, byRef, this.__encryptMode);
        this.__output = (String)response.get("output");
        this.__warning = (PHPRPC_Error)response.get("warning");
        return response.get("result");
    }

    public final void invoke(String function, Object[] args, PHPRPC_Callback callback) {
        this.invoke(function, args, callback, false);
    }

    public final void invoke(String function, Object[] args, PHPRPC_Callback callback, boolean byRef) {
        this.invoke(function, args, callback, byRef, this.__encryptMode);
    }

    public final void invoke(final String function, final Object[] args, final PHPRPC_Callback callback, final boolean byRef, final int encryptMode) {
        final PHPRPC_Client self = this;
        new Thread(new Runnable(){

            public void run() {
                HashMap response = self.invoke(function, args, byRef, encryptMode);
                if (response.get("result") instanceof PHPRPC_Error) {
                    callback.errorHandler((PHPRPC_Error)response.get("result"));
                    return;
                }
                try {
                    block8: for (Method method : callback.getClass().getDeclaredMethods()) {
                        Class<?>[] paramTypes;
                        int len;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        if ((len = (paramTypes = method.getParameterTypes()).length) <= 0) continue;
                        Object result = Cast.cast(response.get("result"), paramTypes[0]);
                        switch (len) {
                            case 1: {
                                if (method.getName().equals("errorHandler") && paramTypes[0] == Throwable.class) continue block8;
                                method.invoke((Object)callback, result);
                                continue block8;
                            }
                            case 2: {
                                method.invoke((Object)callback, result, args);
                                continue block8;
                            }
                            case 3: {
                                method.invoke((Object)callback, result, args, response.get("output"));
                                continue block8;
                            }
                            case 4: {
                                method.invoke((Object)callback, result, args, response.get("output"), response.get("warning"));
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    callback.errorHandler(ex);
                }
            }
        }).start();
    }

    public final HashMap invoke(String function, Object[] args, boolean byRef, int encryptMode) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            HashMap result;
            int errno;
            encryptMode = this.__keyExchange(encryptMode);
            StringBuffer requestBody = new StringBuffer();
            requestBody.append("phprpc_func=").append(function);
            if (args != null && args.length > 0) {
                requestBody.append("&phprpc_args=");
                requestBody.append(Base64.encode(this.__encrypt(this.__phpser.serialize(args), 1, encryptMode)).replaceAll("\\+", "%2B"));
            }
            requestBody.append("&phprpc_encrypt=").append(encryptMode);
            if (!byRef) {
                requestBody.append("&phprpc_ref=false");
            }
            if ((errno = Integer.parseInt((String)(result = this.__post(requestBody.toString())).get("phprpc_errno"))) > 0) {
                String errstr = new String(Base64.decode((String)result.get("phprpc_errstr")), this.__charset);
                response.put("warning", new PHPRPC_Error(errno, errstr));
            } else {
                response.put("warning", null);
            }
            if (result.containsKey("phprpc_output")) {
                byte[] output = Base64.decode((String)result.get("phprpc_output"));
                if (Double.parseDouble((String)this.__server.get("version")) >= 3.0) {
                    output = this.__decrypt(output, 3, encryptMode);
                }
                response.put("output", new String(output, this.__charset));
            } else {
                response.put("output", "");
            }
            if (result.containsKey("phprpc_result")) {
                if (result.containsKey("phprpc_args")) {
                    Object[] arguments = (Object[])this.__phpser.unserialize(this.__decrypt(Base64.decode((String)result.get("phprpc_args")), 1, encryptMode), Object[].class);
                    for (int i = 0; i < Math.min(args.length, arguments.length); ++i) {
                        args[i] = arguments[i];
                    }
                }
                response.put("result", this.__phpser.unserialize(this.__decrypt(Base64.decode((String)result.get("phprpc_result")), 2, encryptMode)));
            } else {
                response.put("result", this.__warning);
            }
        }
        catch (PHPRPC_Error e) {
            response.put("result", e);
        }
        catch (Throwable e) {
            StackTraceElement[] st = e.getStackTrace();
            StringBuffer es = new StringBuffer(e.toString()).append("\r\n");
            int n = st.length;
            for (int i = 0; i < n; ++i) {
                es.append(st[i].toString()).append("\r\n");
            }
            response.put("result", new PHPRPC_Error(1, es.toString()));
        }
        return response;
    }

    private final void __initSocketPool() throws IOException {
        int port;
        String host;
        SocketFactory socketFactory = ((String)this.__server.get("scheme")).equals("https") ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
        if (this.__proxy != null) {
            host = (String)this.__proxy.get("host");
            port = (Integer)this.__proxy.get("port");
        } else {
            host = (String)this.__server.get("host");
            port = (Integer)this.__server.get("port");
        }
        this.__socketPool = new SocketPool(socketFactory, host, port, this.__timeout);
    }

    private final void __sendRequest(String requestBody, Socket socket) throws IOException {
        StringBuffer url = new StringBuffer();
        StringBuffer connection = new StringBuffer();
        if (this.__proxy == null) {
            url.append(this.__server.get("path"));
            connection.append("Connection: ");
            connection.append(this.__keepAlive ? "Keep-Alive" : "close");
            connection.append("\r\n");
            connection.append("Pragma: no-cache\r\n");
            connection.append("Cache-Control: no-cache\r\n");
        } else {
            url.append(this.__server.get("scheme"));
            url.append("://");
            url.append(this.__server.get("host"));
            url.append(":");
            url.append(this.__server.get("port"));
            url.append(this.__server.get("path"));
            connection.append("Proxy-Connection: ");
            connection.append(this.__keepAlive ? "Keep-Alive" : "close");
            connection.append("\r\n");
            if (this.__proxy.get("userinfo") != null) {
                connection.append("Proxy-Authorization: Basic ");
                connection.append(Base64.encode(((String)this.__proxy.get("userinfo")).getBytes(this.__charset)));
                connection.append("\r\n");
            }
        }
        StringBuffer auth = new StringBuffer();
        if (this.__server.get("userinfo") != null) {
            auth.append("Authorization: Basic ");
            auth.append(Base64.encode(((String)this.__server.get("userinfo")).getBytes(this.__charset)));
            auth.append("\r\n");
        }
        StringBuffer cookie = new StringBuffer();
        if (__cookie != null) {
            cookie.append("Cookie: ");
            cookie.append(__cookie);
            cookie.append("\r\n");
        }
        byte[] rb = requestBody.getBytes();
        StringBuffer requestHeader = new StringBuffer();
        requestHeader.append("POST ").append(url).append(" HTTP/1.1\r\n");
        requestHeader.append("Host: ").append(this.__server.get("host")).append(':').append(this.__server.get("port")).append("\r\n");
        requestHeader.append("User-Agent: PHPRPC Client 3.0 for Java\r\n");
        requestHeader.append(auth).append(connection).append(cookie);
        requestHeader.append("Accept: */*\r\n");
        requestHeader.append("Accept-Encoding: gzip,deflate\r\n");
        requestHeader.append("Content-Type: application/x-www-form-urlencoded; charset=").append(this.__charset).append("\r\n");
        requestHeader.append("Content-Length: ").append(rb.length).append("\r\n");
        requestHeader.append("\r\n");
        this.__sendRequest(requestHeader.toString().getBytes(), rb, socket);
    }

    private final void __sendRequest(byte[] header, byte[] body, Socket socket) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(socket.getOutputStream());
        os.write(header);
        os.write(body);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void __parseHeader(HashMap responseHeader) throws PHPRPC_Error {
        ArrayList xPowerdBy = (ArrayList)responseHeader.get("x-powered-by");
        if (xPowerdBy == null) {
            throw new PHPRPC_Error(1, "Illegal PHPRPC server.");
        }
        this.__server.put("version", "0");
        String version = null;
        for (int i = 0; i < xPowerdBy.size(); ++i) {
            String s = (String)xPowerdBy.get(i);
            if (!s.startsWith("PHPRPC Server/")) continue;
            version = s.substring(14);
        }
        if (version == null) {
            throw new PHPRPC_Error(1, "Illegal PHPRPC server.");
        }
        this.__server.put("version", version);
        if (responseHeader.containsKey("content-type")) {
            ArrayList contentType = (ArrayList)responseHeader.get("content-type");
            for (int i = 0; i < contentType.size(); ++i) {
                String s = (String)contentType.get(i);
                if (!s.startsWith("text/plain; charset=")) continue;
                this.setCharset(s.substring(20));
            }
        }
        if (responseHeader.containsKey("set-cookie")) {
            HashMap hashMap = __cookies;
            synchronized (hashMap) {
                String value;
                ArrayList setCookie = (ArrayList)responseHeader.get("set-cookie");
                for (int i = 0; i < setCookie.size(); ++i) {
                    String s = (String)setCookie.get(i);
                    String[] cookies = s.split("[;,]\\s?");
                    for (int j = 0; j < cookies.length; ++j) {
                        String name;
                        String[] pair = cookies[j].split("=", 2);
                        if (pair.length == 2) {
                            name = pair[0];
                            value = pair[1];
                        } else {
                            name = pair[0];
                            value = "";
                        }
                        if (name.equals("domain") || name.equals("expires") || name.equals("path") || name.equals("secure")) continue;
                        __cookies.put(name, value);
                    }
                }
                __cookie = "";
                for (String name : __cookies.keySet()) {
                    value = (String)__cookies.get(name);
                    __cookie = __cookie + name + "=" + value + "; ";
                }
            }
        }
        if (responseHeader.containsKey("content-encoding")) {
            responseHeader.put("content-encoding", ((ArrayList)responseHeader.get("content-encoding")).get(0));
        }
        if (responseHeader.containsKey("transfer-encoding")) {
            responseHeader.put("transfer-encoding", ((ArrayList)responseHeader.get("transfer-encoding")).get(0));
        }
        if (responseHeader.containsKey("content-length")) {
            responseHeader.put("content-length", ((ArrayList)responseHeader.get("content-length")).get(0));
        }
        if (responseHeader.containsKey("connection")) {
            responseHeader.put("connection", ((ArrayList)responseHeader.get("connection")).get(0));
        }
    }

    private final String __readLine(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = is.read()) > -1) {
            if (c == 13) {
                c = is.read();
                if (c != 10) {
                    throw new IOException();
                }
                return sb.toString();
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private final boolean __readCRLF(InputStream is) throws IOException {
        if (is.read() != 13) {
            return false;
        }
        return is.read() == 10;
    }

    private final HashMap __readResponseHeader(String requestBody, Socket socket) throws IOException, PHPRPC_Error {
        return this.__readResponseHeader(requestBody, socket, 0);
    }

    private final HashMap __readResponseHeader(String requestBody, Socket socket, int times) throws IOException, PHPRPC_Error {
        HashMap<String, ArrayList> responseHeader;
        this.__sendRequest(requestBody, socket);
        InputStream is = socket.getInputStream();
        String statuscode = null;
        String status = "";
        do {
            String buf;
            responseHeader = new HashMap<String, ArrayList>();
            while (!(buf = this.__readLine(is)).equals("")) {
                if (buf.startsWith("HTTP/")) {
                    statuscode = buf.substring(9, 12);
                    status = buf.substring(13);
                    continue;
                }
                int pos = buf.indexOf(":");
                if (pos <= -1) continue;
                String name = buf.substring(0, pos).toLowerCase();
                String value = buf.substring(pos + 1).trim();
                ArrayList a = responseHeader.containsKey(name) ? (ArrayList)responseHeader.get(name) : new ArrayList();
                a.add(value);
                responseHeader.put(name, a);
            }
            try {
                if (statuscode == null) {
                    throw new PHPRPC_Error(1, "Illegal HTTP server.");
                }
                if (!statuscode.equals("100") && !statuscode.equals("200")) {
                    try {
                        throw new PHPRPC_Error(Integer.parseInt(statuscode), status);
                    }
                    catch (NumberFormatException e) {
                        throw new PHPRPC_Error(1, statuscode + ":" + status);
                    }
                }
                if (!statuscode.equals("200")) continue;
                this.__parseHeader(responseHeader);
            }
            catch (PHPRPC_Error e) {
                this.__socketPool.freeConnect(socket, false);
                throw e;
            }
        } while (statuscode.equals("100"));
        return responseHeader;
    }

    private final byte[] __ungzip(HashMap responseHeader, byte[] responseBodyByteArray) throws IOException, PHPRPC_Error {
        String contentEncoding = (String)responseHeader.get("content-encoding");
        if (contentEncoding != null && contentEncoding.toLowerCase().equals("gzip")) {
            int len;
            ByteArrayInputStream bais = new ByteArrayInputStream(responseBodyByteArray);
            GZIPInputStream gzipis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = responseBodyByteArray.length;
            byte[] buf = new byte[n];
            while ((len = gzipis.read(buf, 0, n)) > -1) {
                baos.write(buf, 0, len);
            }
            responseBodyByteArray = baos.toByteArray();
        }
        return responseBodyByteArray;
    }

    private final HashMap __parseBody(byte[] responseBodyByteArray) throws IOException, PHPRPC_Error {
        String buf;
        ByteArrayInputStream is = new ByteArrayInputStream(responseBodyByteArray);
        HashMap<String, String> result = new HashMap<String, String>();
        while (!(buf = this.__readLine(is)).equals("")) {
            int p = buf.indexOf("=");
            if (p <= -1) continue;
            result.put(buf.substring(0, p), buf.substring(p + 2, buf.length() - 2));
        }
        return result;
    }

    private final HashMap __readResponseBody(HashMap responseHeader, Socket socket) throws IOException, PHPRPC_Error {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = socket.getInputStream();
        String te = (String)responseHeader.get("transfer-encoding");
        if (te != null && te.toLowerCase().equals("chunked")) {
            String s = this.__readLine(is);
            if (s.equals("")) {
                return new HashMap();
            }
            int n = Integer.parseInt(s, 16);
            while (n > 0) {
                int len;
                byte[] b = new byte[n];
                while (n > 0 && (len = is.read(b, 0, n)) > -1) {
                    baos.write(b, 0, len);
                    n -= len;
                }
                if (!this.__readCRLF(is)) {
                    this.__socketPool.freeConnect(socket, false);
                    throw new PHPRPC_Error(1, "Response is incorrect.");
                }
                n = Integer.parseInt(this.__readLine(is), 16);
            }
            this.__readLine(is);
        } else if (responseHeader.get("content-length") != null) {
            int len;
            int n;
            byte[] b = new byte[n];
            for (n = Integer.parseInt((String)responseHeader.get("content-length")); n > 0 && (len = is.read(b, 0, n)) > -1; n -= len) {
                baos.write(b, 0, len);
            }
        } else {
            int len;
            byte[] b = new byte[2048];
            while ((len = is.read(b, 0, 2048)) > -1) {
                baos.write(b, 0, len);
            }
            this.__keepAlive = false;
        }
        return this.__parseBody(this.__ungzip(responseHeader, baos.toByteArray()));
    }

    private final HashMap __post(String requestBody) throws IOException, PHPRPC_Error {
        HashMap responseBody;
        HashMap responseHeader;
        if (this.__socketPool == null) {
            this.__initSocketPool();
        }
        Socket socket = this.__socketPool.getConnect();
        try {
            responseHeader = this.__readResponseHeader(requestBody, socket);
            responseBody = this.__readResponseBody(responseHeader, socket);
        }
        catch (IOException e) {
            this.__socketPool.freeConnect(socket, false);
            throw e;
        }
        String connection = (String)responseHeader.get("connection");
        if (this.__keepAlive && connection != null && connection.equals("close")) {
            this.__keepAlive = false;
        }
        this.__socketPool.freeConnect(socket, this.__keepAlive);
        return responseBody;
    }

    private final synchronized int __keyExchange(int encryptMode) throws IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchAlgorithmException, PHPRPC_Error {
        if (this.__key != null || encryptMode == 0) {
            return encryptMode;
        }
        if (this.__key == null && this.__keyExchanged) {
            return 0;
        }
        HashMap result = this.__post("phprpc_encrypt=true&phprpc_keylen=" + this.__keylen);
        this.__keylen = result.containsKey("phprpc_keylen") ? Integer.parseInt((String)result.get("phprpc_keylen")) : 128;
        if (result.containsKey("phprpc_encrypt")) {
            byte[] key1;
            HashMap encrypt = (HashMap)this.__phpser.unserialize(Base64.decode((String)result.get("phprpc_encrypt")), HashMap.class);
            BigInteger x = new BigInteger(this.__keylen - 1, new Random()).setBit(this.__keylen - 2);
            BigInteger y = new BigInteger(Cast.toString(encrypt.get("y")));
            BigInteger p = new BigInteger(Cast.toString(encrypt.get("p")));
            BigInteger g = new BigInteger(Cast.toString(encrypt.get("g")));
            BigInteger k = y.modPow(x, p);
            if (this.__keylen == 128) {
                key1 = k.toByteArray();
            } else {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.update(k.toString().getBytes());
                key1 = md5.digest();
            }
            byte[] key2 = new byte[16];
            int n = Math.min(key1.length, 16);
            for (int i = 1; i <= n; ++i) {
                key2[16 - i] = key1[key1.length - i];
            }
            this.__post("phprpc_encrypt=" + g.modPow(x, p).toString());
            this.__key = key2;
        } else {
            this.__key = null;
            this.__keyExchanged = true;
            encryptMode = 0;
        }
        return encryptMode;
    }

    private final byte[] __encrypt(byte[] s, int level, int encryptMode) {
        if (this.__key != null && encryptMode >= level) {
            s = XXTEA.encrypt(s, this.__key);
        }
        return s;
    }

    private final byte[] __decrypt(byte[] s, int level, int encryptMode) {
        if (this.__key != null && encryptMode >= level) {
            s = XXTEA.decrypt(s, this.__key);
        }
        return s;
    }
}

