/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.trace;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mydotey.caravan.util.trace.Trace;
import org.mydotey.caravan.util.trace.TraceFactory;

public class TraceExecutor {
    private TraceFactory _factory;
    private ThreadLocal<Trace> _currentTrace;

    public TraceExecutor(TraceFactory factory) {
        Objects.requireNonNull(factory, "factory");
        this._factory = factory;
        this._currentTrace = new ThreadLocal();
    }

    public <V> V execute(String traceKey, Supplier<V> executor) {
        Trace trace = this._factory.newTrace(traceKey);
        this._currentTrace.set(trace);
        try {
            trace.start();
            V value = executor.get();
            trace.markSuccess();
            V v = value;
            return v;
        }
        catch (Throwable ex) {
            trace.markFail(ex);
            throw ex;
        }
        finally {
            trace.end();
            this._currentTrace.remove();
        }
    }

    public void execute(String traceKey, Runnable executor) {
        Trace trace = this._factory.newTrace(traceKey);
        this._currentTrace.set(trace);
        try {
            trace.start();
            executor.run();
            trace.markSuccess();
        }
        catch (Throwable ex) {
            trace.markFail(ex);
            throw ex;
        }
        finally {
            trace.end();
            this._currentTrace.remove();
        }
    }

    public void markEvent(String message) {
        Trace trace = this._currentTrace.get();
        if (trace == null) {
            return;
        }
        trace.markEvent(message);
    }

    public void markEvent(String message, Map<String, String> data) {
        Trace trace = this._currentTrace.get();
        if (trace == null) {
            return;
        }
        trace.markEvent(message, data);
    }
}

