/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.safelist;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.mydotey.caravan.util.safelist.DefaultSafeList;
import org.mydotey.caravan.util.safelist.SafeList;
import org.mydotey.caravan.util.safelist.SafeListConfig;
import org.mydotey.caravan.util.safelist.SafeListManagerConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.scf.facade.StringProperties;
import org.mydotey.scf.type.string.StringInplaceConverter;

public class SafeListManager<T> {
    private String _managerId;
    private SafeListManagerConfig<T> _config;
    private ConcurrentHashMap<String, SafeList<T>> _listMap = new ConcurrentHashMap();

    public static SafeListManager<String> newManager(StringProperties properties) {
        return new SafeListManager<String>("", new SafeListManagerConfig(properties, StringInplaceConverter.DEFAULT));
    }

    public SafeListManager(String managerId, SafeListManagerConfig<T> config) {
        ObjectExtension.requireNonNull((Object)managerId, (String)"managerId");
        ObjectExtension.requireNonNull(config, (String)"config");
        this._managerId = managerId;
        this._config = config;
    }

    public String managerId() {
        return this._managerId;
    }

    public SafeListManagerConfig<T> config() {
        return this._config;
    }

    public Collection<SafeList<T>> lists() {
        return Collections.unmodifiableCollection(this._listMap.values());
    }

    public SafeList<T> getList(String listId, SafeListConfig<T> config) {
        ObjectExtension.requireNonBlank((String)listId, (String)"listId");
        ObjectExtension.requireNonNull(config, (String)"config");
        String trimmedListId = StringExtension.trim((String)listId);
        return this._listMap.computeIfAbsent(trimmedListId, k -> new DefaultSafeList<T>(trimmedListId, this._config.valueParser(), this._config.properties(), config));
    }
}

