/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.safelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mydotey.caravan.util.safelist.SafeList;
import org.mydotey.caravan.util.safelist.SafeListChecker;
import org.mydotey.caravan.util.safelist.SafeListConfig;
import org.mydotey.scf.Property;
import org.mydotey.scf.facade.StringProperties;
import org.mydotey.scf.type.TypeConverter;
import org.mydotey.scf.util.PropertyKeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSafeList<T>
implements SafeList<T> {
    private static final Logger _logger = LoggerFactory.getLogger(DefaultSafeList.class);
    private String _safeListId;
    private SafeListChecker<T> _checker;
    private Property<String, Boolean> _enabledProperty;
    private Property<String, List<T>> _listProperty;

    public DefaultSafeList(String safeListId, TypeConverter<String, T> valueParser, StringProperties properties, SafeListConfig<T> config) {
        this._safeListId = safeListId;
        this._checker = config.checker();
        String propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._safeListId, "enabled"});
        this._enabledProperty = properties.getBooleanProperty((Object)propertyKey, Boolean.valueOf(config.enabled()));
        propertyKey = PropertyKeyGenerator.generateKey((String)this._safeListId, (String[])new String[]{"list"});
        this._listProperty = properties.getListProperty((Object)propertyKey, config.list() == null ? new ArrayList() : config.list(), valueParser);
    }

    @Override
    public String safeListId() {
        return this._safeListId;
    }

    @Override
    public List<T> list() {
        return Collections.unmodifiableList((List)this._listProperty.getValue());
    }

    @Override
    public boolean check(T item) {
        if (!((Boolean)this._enabledProperty.getValue()).booleanValue()) {
            return true;
        }
        try {
            return this._checker.check((List)this._listProperty.getValue(), item);
        }
        catch (Throwable ex) {
            _logger.error("Safe list failed to check.", ex);
            return true;
        }
    }
}

