/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.ratelimiter;

import java.util.concurrent.ConcurrentHashMap;
import org.mydotey.caravan.util.ratelimiter.DefaultRateLimiter;
import org.mydotey.caravan.util.ratelimiter.RateLimiter;
import org.mydotey.caravan.util.ratelimiter.RateLimiterConfig;
import org.mydotey.caravan.util.ratelimiter.RateLimiterManagerConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;

public class RateLimiterManager {
    private String _managerId;
    private RateLimiterManagerConfig _config;
    private ConcurrentHashMap<String, RateLimiter> _rateLimiterCache;

    public RateLimiterManager(String managerId, RateLimiterManagerConfig config) {
        ObjectExtension.requireNonBlank((String)managerId, (String)"managerId");
        ObjectExtension.requireNonNull((Object)config, (String)"config");
        this._managerId = managerId;
        this._config = config;
        this._rateLimiterCache = new ConcurrentHashMap();
    }

    public String managerId() {
        return this._managerId;
    }

    public RateLimiterManagerConfig config() {
        return this._config;
    }

    public RateLimiter getRateLimiter(String rateLimiterId, RateLimiterConfig rateLimiterConfig) {
        ObjectExtension.requireNonBlank((String)rateLimiterId, (String)"rateLimiterId");
        ObjectExtension.requireNonNull((Object)rateLimiterConfig, (String)"rateLimiterConfig");
        String trimmedRateLimiterId = StringExtension.trim((String)rateLimiterId);
        return this._rateLimiterCache.computeIfAbsent(trimmedRateLimiterId, k -> new DefaultRateLimiter(trimmedRateLimiterId, this._config.properties(), rateLimiterConfig));
    }
}

