/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.ratelimiter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.mydotey.caravan.util.ratelimiter.RateLimiter;
import org.mydotey.caravan.util.ratelimiter.RateLimiterConfig;
import org.mydotey.java.BooleanExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.facade.StringProperties;
import org.mydotey.scf.filter.AbstractValueFilter;
import org.mydotey.scf.filter.PipelineValueFilter;
import org.mydotey.scf.type.TypeConverter;
import org.mydotey.scf.type.string.StringInplaceConverter;
import org.mydotey.scf.type.string.StringToLongConverter;
import org.mydotey.scf.util.PropertyKeyGenerator;
import org.mydotey.util.CounterBuffer;

class DefaultRateLimiter
implements RateLimiter {
    private String _rateLimiterId;
    private Property<String, Boolean> _enabledProperty;
    private Property<String, Long> _defaultRateLimitProperty;
    private Property<String, Map<String, Long>> _rateLimitMapProperty;
    private CounterBuffer<String> _counterBuffer;

    public DefaultRateLimiter(String rateLimiterId, StringProperties properties, RateLimiterConfig rateLimiterConfig) {
        this._rateLimiterId = rateLimiterId;
        String propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._rateLimiterId, "rate-limiter.enabled"});
        this._enabledProperty = properties.getBooleanProperty((Object)propertyKey, Boolean.valueOf(rateLimiterConfig.enabled()));
        propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._rateLimiterId, "rate-limiter.default-rate-limit"});
        this._defaultRateLimitProperty = properties.getLongProperty((Object)propertyKey, rateLimiterConfig.rateLimitPropertyConfig());
        final PipelineValueFilter rateLimitValueCorrector = new PipelineValueFilter(Arrays.asList(rateLimiterConfig.rateLimitPropertyConfig().toDefaultValueFilter(), rateLimiterConfig.rateLimitPropertyConfig().toRangeValueFilter()));
        propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._rateLimiterId, "rate-limiter.rate-limit-map"});
        this._rateLimitMapProperty = properties.getMapProperty((Object)propertyKey, new HashMap(), (TypeConverter)StringInplaceConverter.DEFAULT, (TypeConverter)StringToLongConverter.DEFAULT, (Function)new AbstractValueFilter<Map<String, Long>>(){

            public Map<String, Long> apply(Map<String, Long> v) {
                HashMap<String, Long> result = new HashMap<String, Long>();
                for (Map.Entry<String, Long> item : v.entrySet()) {
                    result.put(item.getKey(), (Long)rateLimitValueCorrector.apply((Object)item.getValue()));
                }
                return result;
            }

            public boolean equals(Object obj) {
                return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
            }
        });
        this._counterBuffer = new CounterBuffer(rateLimiterConfig.bufferConfig());
    }

    @Override
    public String rateLimiterId() {
        return this._rateLimiterId;
    }

    @Override
    public boolean isRateLimited(String identity) {
        if (BooleanExtension.isFalse((Boolean)((Boolean)this._enabledProperty.getValue()))) {
            return false;
        }
        this._counterBuffer.increment((Object)identity);
        if (this._counterBuffer.get((Object)identity) <= this.getRateLimit(identity)) {
            return false;
        }
        this._counterBuffer.decrement((Object)identity);
        return true;
    }

    private long getRateLimit(String identity) {
        Map rateLimitMap = (Map)this._rateLimitMapProperty.getValue();
        Long rateLimit = null;
        if (rateLimitMap != null) {
            rateLimit = (Long)rateLimitMap.get(identity);
        }
        if (rateLimit == null) {
            rateLimit = (Long)this._defaultRateLimitProperty.getValue();
        }
        return rateLimit == null ? Long.MAX_VALUE : rateLimit;
    }
}

