/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.metric;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.mydotey.caravan.util.metric.MetricManagerConfig;
import org.mydotey.caravan.util.metric.NullStatusMetric;
import org.mydotey.caravan.util.metric.NullStatusMetricReporter;
import org.mydotey.caravan.util.metric.StatusMetric;
import org.mydotey.caravan.util.metric.StatusMetricConfig;
import org.mydotey.caravan.util.metric.StatusMetricManager;

public class NullStatusMetricManager<T>
implements StatusMetricManager<T> {
    private static ConcurrentHashMap<Class<?>, NullStatusMetricManager<?>> _managerCache = new ConcurrentHashMap();
    public static final NullStatusMetricManager<Double> DOUBLE_NULL_STATUS_METRIC_MANAGER = NullStatusMetricManager.getInstance(Double.class, 0.0);
    private static final String metricIdPrefix = "null_status_manager_";
    private String _metricId;
    private NullStatusMetric<T> _metric;
    private MetricManagerConfig<StatusMetric<T>> _managerConfig = new MetricManagerConfig(NullStatusMetricReporter.getInstance());

    public static <T> NullStatusMetricManager<T> getInstance(Class<T> statusClass, T status) {
        return _managerCache.computeIfAbsent(statusClass, k -> new NullStatusMetricManager<Object>(status));
    }

    private NullStatusMetricManager(T status) {
        this._metricId = metricIdPrefix + status.getClass().getName();
        this._metric = new NullStatusMetric<T>(status);
    }

    @Override
    public StatusMetric<T> getMetric(String metricId, StatusMetricConfig<T> metricConfig) {
        return this._metric;
    }

    @Override
    public String managerId() {
        return this._metricId;
    }

    @Override
    public MetricManagerConfig<StatusMetric<T>> config() {
        return this._managerConfig;
    }

    @Override
    public Collection<StatusMetric<T>> metrics() {
        return Collections.emptyList();
    }
}

