/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.defensive;

import java.util.function.Supplier;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.ThreadExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Loops {
    private static final Logger _logger = LoggerFactory.getLogger(Loops.class);
    private static final int DEFAULT_SLEEP_NANOS_IN_TIGHT_LOOP = 10000;

    private Loops() {
    }

    public static <V> V executeWithoutTightLoop(Supplier<V> func) {
        return Loops.executeWithoutTightLoop(func, 0, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V executeWithoutTightLoop(Supplier<V> func, int ms, int nanos) {
        ObjectExtension.requireNonNull(func, (String)"func");
        long startTime = System.currentTimeMillis();
        try {
            V v = func.get();
            return v;
        }
        finally {
            if (System.currentTimeMillis() - startTime <= 0L) {
                Loops.preventTightLoop(ms, nanos);
            }
        }
    }

    public static void executeWithoutTightLoop(Runnable action) {
        Loops.executeWithoutTightLoop(action, 0, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithoutTightLoop(Runnable action, int ms, int nanos) {
        ObjectExtension.requireNonNull((Object)action, (String)"action");
        long startTime = System.currentTimeMillis();
        try {
            action.run();
        }
        finally {
            if (System.currentTimeMillis() - startTime <= 0L) {
                Loops.preventTightLoop(ms, nanos);
            }
        }
    }

    public static void preventTightLoop() {
        Loops.preventTightLoop(0, 10000);
    }

    public static void preventTightLoop(int ms, int nanos) {
        _logger.info("Sleep {} ms & {} nanos to prevent tight loop.", (Object)ms, (Object)nanos);
        ThreadExtension.sleep((int)ms, (int)nanos);
    }
}

