/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.caravan.util.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.caravan.util.defensive.Loops;
import org.mydotey.java.InterruptedRuntimeException;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.java.ThreadExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.util.PropertyKeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicScheduledThread
extends Thread {
    private static final Logger _logger = LoggerFactory.getLogger(DynamicScheduledThread.class);
    private String _threadId;
    private Runnable _runnable;
    private final Property<String, Integer> _initDelayProperty;
    private final Property<String, Integer> _runIntervalProperty;
    private final AtomicBoolean _isShutdown = new AtomicBoolean();

    public DynamicScheduledThread(String threadId, Runnable runnable, DynamicScheduledThreadConfig config) {
        ObjectExtension.requireNonBlank((String)threadId, (String)"threadId");
        ObjectExtension.requireNonNull((Object)runnable, (String)"runnable");
        ObjectExtension.requireNonNull((Object)config, (String)"config");
        this._threadId = StringExtension.trim((String)threadId);
        this._runnable = runnable;
        this.setName(this._threadId);
        String propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._threadId, "dynamic-scheduled-thread.init-delay"});
        this._initDelayProperty = config.properties().getIntProperty((Object)propertyKey, config.initDelayRange());
        propertyKey = PropertyKeyGenerator.generatePropertyKey((String[])new String[]{this._threadId, "dynamic-scheduled-thread.run-interval"});
        this._runIntervalProperty = config.properties().getIntProperty((Object)propertyKey, config.runIntervalRange());
    }

    @Override
    public final void run() {
        try {
            int initdelay = (Integer)this._initDelayProperty.getValue();
            if (initdelay > 0) {
                ThreadExtension.sleep((int)initdelay);
            }
            while (!this.isInterrupted()) {
                if (this._isShutdown.get()) {
                    return;
                }
                Loops.executeWithoutTightLoop(() -> {
                    try {
                        this._runnable.run();
                    }
                    catch (Throwable ex) {
                        _logger.error("failed to run scheduled runnable", ex);
                    }
                    if (this._isShutdown.get()) {
                        return;
                    }
                    int runInterval = (Integer)this._runIntervalProperty.getValue();
                    if (runInterval > 0) {
                        ThreadExtension.sleep((int)runInterval);
                    }
                });
            }
        }
        catch (InterruptedRuntimeException interruptedRuntimeException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this._isShutdown.set(true);
        this.interrupt();
    }
}

