/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.csselly.CSSellyException;
import jodd.csselly.Selector;
import jodd.csselly.selector.PseudoClass;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;
import jodd.lagarto.dom.NodeListFilter;

public class PseudoClassSelector
extends Selector
implements NodeFilter,
NodeListFilter {
    protected static final Map<String, PseudoClass> PSEUDO_CLASS_MAP = new HashMap<String, PseudoClass>(26);
    protected final PseudoClass pseudoClass;

    public static void registerPseudoClass(Class<? extends PseudoClass> pseudoClassType) {
        PseudoClass pseudoClass;
        try {
            pseudoClass = pseudoClassType.newInstance();
        }
        catch (Exception ex) {
            throw new CSSellyException(ex);
        }
        PSEUDO_CLASS_MAP.put(pseudoClass.getPseudoClassName(), pseudoClass);
    }

    public static PseudoClass lookupPseudoClass(String pseudoClassName) {
        PseudoClass pseudoClass = PSEUDO_CLASS_MAP.get(pseudoClassName);
        if (pseudoClass == null) {
            throw new CSSellyException("Unsupported pseudo class: " + pseudoClassName);
        }
        return pseudoClass;
    }

    public PseudoClassSelector(String pseudoClassName) {
        super(Selector.Type.PSEUDO_CLASS);
        this.pseudoClass = PseudoClassSelector.lookupPseudoClass(pseudoClassName.trim());
    }

    public PseudoClass getPseudoClass() {
        return this.pseudoClass;
    }

    @Override
    public boolean accept(Node node) {
        return this.pseudoClass.match(node);
    }

    @Override
    public boolean accept(List<Node> currentResults, Node node, int index) {
        return this.pseudoClass.match(currentResults, node, index);
    }

    static {
        PseudoClassSelector.registerPseudoClass(PseudoClass.EMPTY.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.FIRST_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.FIRST_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.LAST_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.LAST_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.ONLY_CHILD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.ONLY_OF_TYPE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.ROOT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.FIRST.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.LAST.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.BUTTON.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.CHECKBOX.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.FILE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.IMAGE.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.INPUT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.HEADER.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.PARENT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.PASSWORD.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.RADIO.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.RESET.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.SELECTED.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.CHECKED.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.SUBMIT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.TEXT.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.EVEN.class);
        PseudoClassSelector.registerPseudoClass(PseudoClass.ODD.class);
    }
}

