/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.joda.money.BigMoney;
import org.joda.money.format.MoneyFormatterBuilder;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

final class MultiPrinterParser
implements MoneyPrinter,
MoneyParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MoneyPrinter[] printers;
    private final MoneyParser[] parsers;

    MultiPrinterParser(MoneyPrinter[] printers, MoneyParser[] parsers) {
        this.printers = printers;
        this.parsers = parsers;
    }

    boolean isPrinter() {
        return !Arrays.asList(this.printers).contains(null);
    }

    boolean isParser() {
        return !Arrays.asList(this.parsers).contains(null);
    }

    void appendTo(MoneyFormatterBuilder builder) {
        for (int i = 0; i < this.printers.length; ++i) {
            builder.append(this.printers[i], this.parsers[i]);
        }
    }

    @Override
    public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
        for (MoneyPrinter printer : this.printers) {
            printer.print(context, appendable, money);
        }
    }

    @Override
    public void parse(MoneyParseContext context) {
        for (MoneyParser parser : this.parsers) {
            parser.parse(context);
            if (context.isError()) break;
        }
    }

    public String toString() {
        StringBuilder buf1 = new StringBuilder();
        if (this.isPrinter()) {
            for (MoneyPrinter printer : this.printers) {
                buf1.append(printer.toString());
            }
        }
        StringBuilder buf2 = new StringBuilder();
        if (this.isParser()) {
            for (MoneyParser parser : this.parsers) {
                buf2.append(parser.toString());
            }
        }
        String str1 = buf1.toString();
        String str2 = buf2.toString();
        if (this.isPrinter() && !this.isParser()) {
            return str1;
        }
        if (this.isParser() && !this.isPrinter()) {
            return str2;
        }
        if (str1.equals(str2)) {
            return str1;
        }
        return str1 + ":" + str2;
    }
}

