/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import org.joda.money.BigMoney;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

final class LiteralPrinterParser
implements MoneyPrinter,
MoneyParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String literal;

    LiteralPrinterParser(String literal) {
        this.literal = literal;
    }

    @Override
    public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
        appendable.append(this.literal);
    }

    @Override
    public void parse(MoneyParseContext context) {
        int endPos = context.getIndex() + this.literal.length();
        if (endPos <= context.getTextLength() && context.getTextSubstring(context.getIndex(), endPos).equals(this.literal)) {
            context.setIndex(endPos);
        } else {
            context.setError();
        }
    }

    public String toString() {
        return "'" + this.literal + "'";
    }
}

