/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Iterator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.CurrencyUnit;
import org.joda.money.MoneyUtils;
import org.joda.money.Ser;

public final class Money
implements BigMoneyProvider,
Comparable<BigMoneyProvider>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BigMoney money;

    public static Money of(CurrencyUnit currency, BigDecimal amount) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        MoneyUtils.checkNotNull(amount, "Amount must not be null");
        if (amount.scale() > currency.getDecimalPlaces()) {
            throw new ArithmeticException("Scale of amount " + amount + " is greater than the scale of the currency " + currency);
        }
        return Money.of(currency, amount, RoundingMode.UNNECESSARY);
    }

    public static Money of(CurrencyUnit currency, BigDecimal amount, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(currency, "CurrencyUnit must not be null");
        MoneyUtils.checkNotNull(amount, "Amount must not be null");
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        amount = amount.setScale(currency.getDecimalPlaces(), roundingMode);
        return new Money(BigMoney.of(currency, amount));
    }

    public static Money of(CurrencyUnit currency, double amount) {
        return Money.of(currency, BigDecimal.valueOf(amount));
    }

    public static Money of(CurrencyUnit currency, double amount, RoundingMode roundingMode) {
        return Money.of(currency, BigDecimal.valueOf(amount), roundingMode);
    }

    public static Money ofMajor(CurrencyUnit currency, long amountMajor) {
        return Money.of(currency, BigDecimal.valueOf(amountMajor), RoundingMode.UNNECESSARY);
    }

    public static Money ofMinor(CurrencyUnit currency, long amountMinor) {
        return new Money(BigMoney.ofMinor(currency, amountMinor));
    }

    public static Money zero(CurrencyUnit currency) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        BigDecimal bd = BigDecimal.valueOf(0L, currency.getDecimalPlaces());
        return new Money(BigMoney.of(currency, bd));
    }

    public static Money of(BigMoneyProvider moneyProvider) {
        return Money.of(moneyProvider, RoundingMode.UNNECESSARY);
    }

    public static Money of(BigMoneyProvider moneyProvider, RoundingMode roundingMode) {
        MoneyUtils.checkNotNull(moneyProvider, "BigMoneyProvider must not be null");
        MoneyUtils.checkNotNull((Object)roundingMode, "RoundingMode must not be null");
        return new Money(BigMoney.of(moneyProvider).withCurrencyScale(roundingMode));
    }

    public static Money total(Money ... monies) {
        MoneyUtils.checkNotNull(monies, "Money array must not be null");
        if (monies.length == 0) {
            throw new IllegalArgumentException("Money array must not be empty");
        }
        Money total = monies[0];
        MoneyUtils.checkNotNull(total, "Money arary must not contain null entries");
        for (int i = 1; i < monies.length; ++i) {
            total = total.plus(monies[i]);
        }
        return total;
    }

    public static Money total(Iterable<Money> monies) {
        MoneyUtils.checkNotNull(monies, "Money iterator must not be null");
        Iterator<Money> it = monies.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Money iterator must not be empty");
        }
        Money total = it.next();
        MoneyUtils.checkNotNull(total, "Money iterator must not contain null entries");
        while (it.hasNext()) {
            total = total.plus(it.next());
        }
        return total;
    }

    public static Money total(CurrencyUnit currency, Money ... monies) {
        return Money.zero(currency).plus(Arrays.asList(monies));
    }

    public static Money total(CurrencyUnit currency, Iterable<Money> monies) {
        return Money.zero(currency).plus(monies);
    }

    @FromString
    public static Money parse(String moneyStr) {
        return Money.of(BigMoney.parse(moneyStr));
    }

    private Money() {
        this.money = null;
    }

    Money(BigMoney money) {
        assert (money != null) : "Joda-Money bug: BigMoney must not be null";
        assert (money.isCurrencyScale()) : "Joda-Money bug: Only currency scale is valid for Money";
        this.money = money;
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization delegate required");
    }

    private Object writeReplace() {
        return new Ser(77, this);
    }

    private Money with(BigMoney newInstance) {
        if (this.money.equals(newInstance)) {
            return this;
        }
        return new Money(newInstance);
    }

    public CurrencyUnit getCurrencyUnit() {
        return this.money.getCurrencyUnit();
    }

    public Money withCurrencyUnit(CurrencyUnit currency) {
        return this.withCurrencyUnit(currency, RoundingMode.UNNECESSARY);
    }

    public Money withCurrencyUnit(CurrencyUnit currency, RoundingMode roundingMode) {
        return this.with(this.money.withCurrencyUnit(currency).withCurrencyScale(roundingMode));
    }

    public int getScale() {
        return this.money.getScale();
    }

    public BigDecimal getAmount() {
        return this.money.getAmount();
    }

    public BigDecimal getAmountMajor() {
        return this.money.getAmountMajor();
    }

    public long getAmountMajorLong() {
        return this.money.getAmountMajorLong();
    }

    public int getAmountMajorInt() {
        return this.money.getAmountMajorInt();
    }

    public BigDecimal getAmountMinor() {
        return this.money.getAmountMinor();
    }

    public long getAmountMinorLong() {
        return this.money.getAmountMinorLong();
    }

    public int getAmountMinorInt() {
        return this.money.getAmountMinorInt();
    }

    public int getMinorPart() {
        return this.money.getMinorPart();
    }

    public boolean isZero() {
        return this.money.isZero();
    }

    public boolean isPositive() {
        return this.money.isPositive();
    }

    public boolean isPositiveOrZero() {
        return this.money.isPositiveOrZero();
    }

    public boolean isNegative() {
        return this.money.isNegative();
    }

    public boolean isNegativeOrZero() {
        return this.money.isNegativeOrZero();
    }

    public Money withAmount(BigDecimal amount) {
        return this.withAmount(amount, RoundingMode.UNNECESSARY);
    }

    public Money withAmount(BigDecimal amount, RoundingMode roundingMode) {
        return this.with(this.money.withAmount(amount).withCurrencyScale(roundingMode));
    }

    public Money withAmount(double amount) {
        return this.withAmount(amount, RoundingMode.UNNECESSARY);
    }

    public Money withAmount(double amount, RoundingMode roundingMode) {
        return this.with(this.money.withAmount(amount).withCurrencyScale(roundingMode));
    }

    public Money plus(Iterable<Money> moniesToAdd) {
        return this.with(this.money.plus(moniesToAdd));
    }

    public Money plus(Money moneyToAdd) {
        return this.with(this.money.plus(moneyToAdd));
    }

    public Money plus(BigDecimal amountToAdd) {
        return this.plus(amountToAdd, RoundingMode.UNNECESSARY);
    }

    public Money plus(BigDecimal amountToAdd, RoundingMode roundingMode) {
        return this.with(this.money.plusRetainScale(amountToAdd, roundingMode));
    }

    public Money plus(double amountToAdd) {
        return this.plus(amountToAdd, RoundingMode.UNNECESSARY);
    }

    public Money plus(double amountToAdd, RoundingMode roundingMode) {
        return this.with(this.money.plusRetainScale(amountToAdd, roundingMode));
    }

    public Money plusMajor(long amountToAdd) {
        return this.with(this.money.plusMajor(amountToAdd));
    }

    public Money plusMinor(long amountToAdd) {
        return this.with(this.money.plusMinor(amountToAdd));
    }

    public Money minus(Iterable<Money> moniesToSubtract) {
        return this.with(this.money.minus(moniesToSubtract));
    }

    public Money minus(Money moneyToSubtract) {
        return this.with(this.money.minus(moneyToSubtract));
    }

    public Money minus(BigDecimal amountToSubtract) {
        return this.minus(amountToSubtract, RoundingMode.UNNECESSARY);
    }

    public Money minus(BigDecimal amountToSubtract, RoundingMode roundingMode) {
        return this.with(this.money.minusRetainScale(amountToSubtract, roundingMode));
    }

    public Money minus(double amountToSubtract) {
        return this.minus(amountToSubtract, RoundingMode.UNNECESSARY);
    }

    public Money minus(double amountToSubtract, RoundingMode roundingMode) {
        return this.with(this.money.minusRetainScale(amountToSubtract, roundingMode));
    }

    public Money minusMajor(long amountToSubtract) {
        return this.with(this.money.minusMajor(amountToSubtract));
    }

    public Money minusMinor(long amountToSubtract) {
        return this.with(this.money.minusMinor(amountToSubtract));
    }

    public Money multipliedBy(BigDecimal valueToMultiplyBy, RoundingMode roundingMode) {
        return this.with(this.money.multiplyRetainScale(valueToMultiplyBy, roundingMode));
    }

    public Money multipliedBy(double valueToMultiplyBy, RoundingMode roundingMode) {
        return this.with(this.money.multiplyRetainScale(valueToMultiplyBy, roundingMode));
    }

    public Money multipliedBy(long valueToMultiplyBy) {
        return this.with(this.money.multipliedBy(valueToMultiplyBy));
    }

    public Money dividedBy(BigDecimal valueToDivideBy, RoundingMode roundingMode) {
        return this.with(this.money.dividedBy(valueToDivideBy, roundingMode));
    }

    public Money dividedBy(double valueToDivideBy, RoundingMode roundingMode) {
        return this.with(this.money.dividedBy(valueToDivideBy, roundingMode));
    }

    public Money dividedBy(long valueToDivideBy, RoundingMode roundingMode) {
        return this.with(this.money.dividedBy(valueToDivideBy, roundingMode));
    }

    public Money negated() {
        return this.with(this.money.negated());
    }

    public Money abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public Money rounded(int scale, RoundingMode roundingMode) {
        return this.with(this.money.rounded(scale, roundingMode));
    }

    public Money convertedTo(CurrencyUnit currency, BigDecimal conversionMultipler, RoundingMode roundingMode) {
        return this.with(this.money.convertedTo(currency, conversionMultipler).withCurrencyScale(roundingMode));
    }

    @Override
    public BigMoney toBigMoney() {
        return this.money;
    }

    public boolean isSameCurrency(BigMoneyProvider other) {
        return this.money.isSameCurrency(other);
    }

    @Override
    public int compareTo(BigMoneyProvider other) {
        return this.money.compareTo(other);
    }

    public boolean isEqual(BigMoneyProvider other) {
        return this.money.isEqual(other);
    }

    public boolean isGreaterThan(BigMoneyProvider other) {
        return this.money.isGreaterThan(other);
    }

    public boolean isLessThan(BigMoneyProvider other) {
        return this.money.isLessThan(other);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Money) {
            Money otherMoney = (Money)other;
            return this.money.equals(otherMoney.money);
        }
        return false;
    }

    public int hashCode() {
        return this.money.hashCode() + 3;
    }

    @ToString
    public String toString() {
        return this.money.toString();
    }
}

