/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mockit.coverage.modification.ClassSelection;
import mockit.coverage.modification.CoverageModifier;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.coverage.standalone.Startup;
import mockit.external.asm.ClassReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassModification {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    @NotNull
    private final Set<String> modifiedClasses = new HashSet<String>();
    @NotNull
    final List<ProtectionDomain> protectionDomains = new ArrayList<ProtectionDomain>();
    @NotNull
    private final ClassSelection classSelection = new ClassSelection();

    public ClassModification() {
        this.redefineClassesAlreadyLoadedForCoverage();
    }

    private void redefineClassesAlreadyLoadedForCoverage() {
        Class[] loadedClasses;
        Instrumentation inst = Startup.instrumentation();
        Class<?>[] previousLoadedClasses = NO_CLASSES;
        while ((loadedClasses = inst.getAllLoadedClasses()).length > previousLoadedClasses.length) {
            this.redefineClassesForCoverage(previousLoadedClasses, loadedClasses);
            previousLoadedClasses = loadedClasses;
        }
    }

    private void redefineClassesForCoverage(@NotNull Class<?>[] previousClasses, @NotNull Class<?>[] newClasses) {
        int m = previousClasses.length;
        int n = newClasses.length;
        for (int i = 0; i < n; ++i) {
            Class<?> loadedClass = newClasses[i];
            if (i < m && loadedClass == previousClasses[i] || loadedClass.getClassLoader() == null || loadedClass.isAnnotation() || loadedClass.isSynthetic() || !this.isToBeConsideredForCoverage(loadedClass.getName(), loadedClass.getProtectionDomain())) continue;
            this.redefineClassForCoverage(loadedClass);
        }
    }

    private void redefineClassForCoverage(@NotNull Class<?> loadedClass) {
        byte[] modifiedClassfile = ClassModification.readAndModifyClassForCoverage(loadedClass);
        if (modifiedClassfile != null) {
            ClassModification.redefineClassForCoverage(loadedClass, modifiedClassfile);
            this.registerModifiedClass(loadedClass.getName(), loadedClass.getProtectionDomain());
        }
    }

    private void registerModifiedClass(@NotNull String className, @NotNull ProtectionDomain pd) {
        this.modifiedClasses.add(className);
        if (pd.getClassLoader() != null && pd.getCodeSource() != null && pd.getCodeSource().getLocation() != null) {
            this.addProtectionDomainIfHasUniqueNewPath(pd);
        }
    }

    private void addProtectionDomainIfHasUniqueNewPath(@NotNull ProtectionDomain newPD) {
        String newPath = newPD.getCodeSource().getLocation().getPath();
        for (int i = this.protectionDomains.size() - 1; i >= 0; --i) {
            ProtectionDomain previousPD = this.protectionDomains.get(i);
            String previousPath = previousPD.getCodeSource().getLocation().getPath();
            if (previousPath.startsWith(newPath)) {
                return;
            }
            if (!newPath.startsWith(previousPath)) continue;
            this.protectionDomains.set(i, newPD);
            return;
        }
        this.protectionDomains.add(newPD);
    }

    @Nullable
    private static byte[] readAndModifyClassForCoverage(@NotNull Class<?> aClass) {
        try {
            return ClassModification.modifyClassForCoverage(aClass);
        }
        catch (VisitInterruptedException ignore) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        return null;
    }

    @Nullable
    private static byte[] modifyClassForCoverage(@NotNull Class<?> aClass) {
        String className = aClass.getName();
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = CoverageModifier.createClassReader(aClass);
        return cr == null ? null : ClassModification.modifyClassForCoverage(cr);
    }

    @NotNull
    private static byte[] modifyClassForCoverage(@NotNull ClassReader cr) {
        CoverageModifier modifier = new CoverageModifier(cr);
        cr.accept(modifier, 4);
        return modifier.toByteArray();
    }

    private static void redefineClassForCoverage(@NotNull Class<?> loadedClass, @NotNull byte[] modifiedClassfile) {
        ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(loadedClass, modifiedClassfile)};
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldConsiderClassesNotLoaded() {
        return !this.classSelection.loadedOnly;
    }

    boolean isToBeConsideredForCoverage(@NotNull String className, @NotNull ProtectionDomain protectionDomain) {
        return !this.modifiedClasses.contains(className) && this.classSelection.isSelected(className, protectionDomain);
    }

    @Nullable
    public byte[] modifyClass(@NotNull String className, @NotNull ProtectionDomain protectionDomain, @NotNull byte[] originalClassfile) {
        boolean modifyClassForCoverage = this.isToBeConsideredForCoverage(className, protectionDomain);
        if (modifyClassForCoverage) {
            try {
                byte[] modifiedClassfile = ClassModification.modifyClassForCoverage(className, originalClassfile);
                this.registerModifiedClass(className, protectionDomain);
                return modifiedClassfile;
            }
            catch (VisitInterruptedException ignore) {
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
            }
        }
        return null;
    }

    @NotNull
    private static byte[] modifyClassForCoverage(@NotNull String className, @NotNull byte[] classBytecode) {
        byte[] modifiedBytecode = CoverageModifier.recoverModifiedByteCodeIfAvailable(className);
        if (modifiedBytecode != null) {
            return modifiedBytecode;
        }
        ClassReader cr = new ClassReader(classBytecode);
        return ClassModification.modifyClassForCoverage(cr);
    }
}

