/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mockit.coverage.data.CoverageData;
import org.jetbrains.annotations.NotNull;

final class DataFileMerging {
    @NotNull
    private final List<File> inputFiles;

    DataFileMerging(@NotNull String[] inputPaths) {
        this.inputFiles = new ArrayList<File>(inputPaths.length);
        for (String path : inputPaths) {
            this.addInputFileToList(path.trim());
        }
    }

    private void addInputFileToList(@NotNull String path) {
        if (!path.isEmpty()) {
            File inputFile = new File(path);
            if (inputFile.isDirectory()) {
                inputFile = new File(inputFile, "coverage.ser");
            }
            this.inputFiles.add(inputFile);
        }
    }

    @NotNull
    CoverageData merge() throws IOException {
        CoverageData mergedData = null;
        for (File inputFile : this.inputFiles) {
            if (!inputFile.exists()) continue;
            CoverageData existingData = CoverageData.readDataFromFile(inputFile);
            if (mergedData == null) {
                mergedData = existingData;
                continue;
            }
            mergedData.merge(existingData);
        }
        if (mergedData == null) {
            throw new IllegalArgumentException("No input \"coverage.ser\" files found");
        }
        return mergedData;
    }
}

