/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.jeecgframework.poi.cache.manager.POICacheManager;

public class ImageCache {
    private static LoadingCache<String, byte[]> loadingCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(2000L).build((CacheLoader)new CacheLoader<String, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] load(String imagePath) throws Exception {
            InputStream is = POICacheManager.getFile(imagePath);
            BufferedImage bufferImg = ImageIO.read(is);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferImg, imagePath.substring(imagePath.indexOf(".") + 1, imagePath.length()), byteArrayOut);
                byte[] byArray = byteArrayOut.toByteArray();
                return byArray;
            }
            finally {
                IOUtils.closeQuietly((Closeable)is);
                IOUtils.closeQuietly((Closeable)byteArrayOut);
            }
        }
    });

    public static byte[] getImage(String imagePath) {
        try {
            return (byte[])loadingCache.get((Object)imagePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setLoadingCache(LoadingCache<String, byte[]> loadingCache) {
        ImageCache.loadingCache = loadingCache;
    }
}

