/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorPropertyBridgeNode<P>
extends PojoIndexingProcessor<P> {
    private final BeanHolder<? extends PropertyBridge> bridgeHolder;

    public PojoIndexingProcessorPropertyBridgeNode(BeanHolder<? extends PropertyBridge> bridgeHolder) {
        this.bridgeHolder = bridgeHolder;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PropertyBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"apply property bridge");
        builder.attribute("bridge", this.bridgeHolder);
    }

    @Override
    public final void process(DocumentElement target, P source, PojoIndexingProcessorSessionContext sessionContext) {
        ((PropertyBridge)this.bridgeHolder.get()).write(target, source, sessionContext.propertyBridgeWriteContext());
    }
}

