/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanDelegatingBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DocumentIdProcessor
implements PropertyMappingAnnotationProcessor<DocumentId> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    @Override
    public void process(PropertyMappingStep mappingContext, DocumentId annotation, PropertyMappingAnnotationProcessorContext context) {
        IdentifierBinder binder = this.createIdentifierBinder(annotation, context);
        mappingContext.documentId().identifierBinder(binder);
    }

    private IdentifierBinder createIdentifierBinder(DocumentId annotation, MappingAnnotationProcessorContext context) {
        IdentifierBridgeRef bridgeReferenceAnnotation = annotation.identifierBridge();
        IdentifierBinderRef binderReferenceAnnotation = annotation.identifierBinder();
        Optional<BeanReference<? extends IdentifierBridge>> bridgeReference = context.toBeanReference(IdentifierBridge.class, IdentifierBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        Optional<BeanReference<? extends IdentifierBinder>> binderReference = context.toBeanReference(IdentifierBinder.class, IdentifierBinderRef.UndefinedBinderImplementationType.class, binderReferenceAnnotation.type(), binderReferenceAnnotation.name());
        if (bridgeReference.isPresent() && binderReference.isPresent()) {
            throw log.invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference();
        }
        if (bridgeReference.isPresent()) {
            return new BeanBinder(bridgeReference.get());
        }
        if (binderReference.isPresent()) {
            return new BeanDelegatingBinder(binderReference.get());
        }
        return null;
    }
}

