/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.ClassLoadingExceptionSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtracter;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import sun.reflect.annotation.ExceptionProxy;

public class ReflectionDataBuilder
extends ConditionalConfigurationRegistry
implements RuntimeReflectionSupport,
ReflectionHostedSupport {
    private final Set<Class<?>> modifiedClasses = ConcurrentHashMap.newKeySet();
    private boolean sealed;
    private final Set<Class<?>> reflectionClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, Throwable> inaccessibleClasses = new ConcurrentHashMap<String, Throwable>();
    private final Set<Class<?>> unsafeInstantiatedClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Executable, ExecutableAccessibility> reflectionMethods = new ConcurrentHashMap<Executable, ExecutableAccessibility>();
    private final Map<Executable, Object> methodAccessors = new ConcurrentHashMap<Executable, Object>();
    private final Set<Field> reflectionFields = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnalysisField> hidingFields = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> hidingMethods = ConcurrentHashMap.newKeySet();
    private final Map<Executable, AnalysisMethod> registeredMethods = new ConcurrentHashMap<Executable, AnalysisMethod>();
    private final Map<Field, AnalysisField> registeredFields = new ConcurrentHashMap<Field, AnalysisField>();
    private final Map<Class<?>, Object[]> registeredRecordComponents = new ConcurrentHashMap();
    private final Set<DynamicHub> heapDynamicHubs = ConcurrentHashMap.newKeySet();
    private final Set<AccessibleObject> heapReflectionObjects = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, Set<Class<?>>> innerClasses = new ConcurrentHashMap();
    private final Map<Type, Integer> processedTypes = new HashMap<Type, Integer>();
    private final Set<DynamicHub> processedDynamicHubs = new HashSet<DynamicHub>();
    private final Map<AnalysisField, Set<AnalysisType>> processedHidingFields = new HashMap<AnalysisField, Set<AnalysisType>>();
    private final Map<AnalysisMethod, Set<AnalysisType>> processedHidingMethods = new HashMap<AnalysisMethod, Set<AnalysisType>>();
    private final Map<AccessibleObject, AnalysisElement> processedHeapReflectionObjects = new ConcurrentHashMap<AccessibleObject, AnalysisElement>();
    private final Map<Class<?>, Set<Member>> annotationMembers = new HashMap();
    private final Map<AnnotatedElement, AnnotationValue[]> filteredAnnotations = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<AnalysisMethod, AnnotationValue[][]> filteredParameterAnnotations = new ConcurrentHashMap<AnalysisMethod, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> filteredTypeAnnotations = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final SubstrateAnnotationExtracter annotationExtracter;
    private final Method getEnclosingMethod0 = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];

    ReflectionDataBuilder(SubstrateAnnotationExtracter annotationExtracter) {
        this.annotationExtracter = annotationExtracter;
    }

    public void register(ConfigurationCondition condition, boolean unsafeInstantiated, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> {
            if (unsafeInstantiated) {
                this.unsafeInstantiatedClasses.add(clazz);
            }
            if (this.reflectionClasses.add(clazz)) {
                this.modifiedClasses.add(clazz);
            }
        });
    }

    public void registerClassLookupException(ConfigurationCondition condition, String typeName, Throwable t) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.inaccessibleClasses.put(typeName, t));
    }

    public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... methods) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerMethods(queriedOnly, methods));
    }

    private void registerMethods(boolean queriedOnly, Executable[] methods) {
        for (Executable method : methods) {
            ExecutableAccessibility newValue;
            ExecutableAccessibility oldValue;
            do {
                newValue = queriedOnly ? ExecutableAccessibility.QueriedOnly : ExecutableAccessibility.Accessed;
                oldValue = this.reflectionMethods.get(method);
                if (oldValue == null) continue;
                newValue = ExecutableAccessibility.max(oldValue, newValue);
            } while (oldValue != null ? !this.reflectionMethods.replace(method, oldValue, newValue) : this.reflectionMethods.putIfAbsent(method, newValue) != null);
            if (oldValue == newValue) continue;
            this.modifiedClasses.add(method.getDeclaringClass());
        }
    }

    public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerFields(fields));
    }

    private void registerFields(Field[] fields) {
        for (Field field : fields) {
            if (!this.reflectionFields.add(field)) continue;
            this.modifiedClasses.add(field.getDeclaringClass());
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw UserError.abort("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
        }
    }

    protected void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.processAnnotationProxyTypes(access);
        this.processRegisteredElements(access);
        this.processMethodMetadata(access);
    }

    private void processAnnotationProxyTypes(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (AnalysisType type : access.getUniverse().getTypes()) {
            if (!(type.getWrappedWithoutResolve() instanceof AnnotationSubstitutionType)) continue;
            ResolvedJavaType annotationType = ((AnnotationSubstitutionType)type.getWrappedWithoutResolve()).getAnnotationInterfaceType();
            Class annotationClass = access.getUniverse().lookup((JavaType)annotationType).getJavaClass();
            if (!this.annotationMembers.containsKey(annotationClass)) {
                this.processClass(access, annotationClass);
            }
            for (Member member : this.annotationMembers.get(annotationClass)) {
                try {
                    Class annotationProxyClass = type.getJavaClass();
                    if (member instanceof Field) {
                        Field field = (Field)member;
                        this.register(ConfigurationCondition.alwaysTrue(), false, annotationProxyClass.getDeclaredField(field.getName()));
                        continue;
                    }
                    if (!(member instanceof Method)) continue;
                    Method method = (Method)member;
                    this.register(ConfigurationCondition.alwaysTrue(), false, annotationProxyClass.getDeclaredMethod(method.getName(), method.getParameterTypes()));
                }
                catch (NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {}
            }
        }
    }

    protected void processMethodMetadata(FeatureImpl.DuringAnalysisAccessImpl access) {
        AnalysisMethod analysisMethod;
        AnalysisField analysisField;
        for (DynamicHub hub : this.heapDynamicHubs) {
            AnalysisType type;
            if (this.processedDynamicHubs.contains(hub) || SubstitutionReflectivityFilter.shouldExclude((type = access.getHostVM().lookupType(hub)).getJavaClass(), access.getMetaAccess(), access.getUniverse())) continue;
            this.registerTypesForClass(access, type, type.getJavaClass());
            this.processedDynamicHubs.add(hub);
        }
        for (Field reflectField : this.reflectionFields) {
            if (this.registeredFields.containsKey(reflectField) || SubstitutionReflectivityFilter.shouldExclude(reflectField, access.getMetaAccess(), access.getUniverse())) continue;
            analysisField = access.getMetaAccess().lookupJavaField(reflectField);
            access.requireAnalysisIteration();
            this.registerTypesForField(access, analysisField, reflectField);
            this.registeredFields.put(reflectField, analysisField);
        }
        for (AnalysisField registeredField : this.registeredFields.values()) {
            this.registerHidingSubTypeFields(access, registeredField, registeredField.getDeclaringClass());
        }
        for (Executable method : this.reflectionMethods.keySet()) {
            SubstrateAccessor accessor;
            if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            if (!this.registeredMethods.containsKey(method)) {
                analysisMethod = access.getMetaAccess().lookupJavaMethod(method);
                access.requireAnalysisIteration();
                this.registerTypesForMethod(access, analysisMethod, method);
                this.registeredMethods.put(method, analysisMethod);
            }
            if (this.reflectionMethods.get(method) != ExecutableAccessibility.Accessed || this.methodAccessors.putIfAbsent(method, accessor = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(method)) != null) continue;
            access.rescanObject(accessor);
        }
        for (AnalysisMethod registeredMethod : this.registeredMethods.values()) {
            this.registerHidingSubTypeMethods(access, registeredMethod, registeredMethod.getDeclaringClass());
        }
        for (AccessibleObject object : this.heapReflectionObjects) {
            Executable executable;
            if (this.processedHeapReflectionObjects.containsKey(object)) continue;
            AnalysisField analysisElement = null;
            if (object instanceof Field) {
                Field field = (Field)object;
                if (!SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) {
                    analysisElement = access.getMetaAccess().lookupJavaField(field);
                    access.requireAnalysisIteration();
                    this.registerTypesForField(access, analysisElement, field);
                }
            } else if (object instanceof Executable && !SubstitutionReflectivityFilter.shouldExclude(executable = (Executable)object, access.getMetaAccess(), access.getUniverse())) {
                analysisElement = access.getMetaAccess().lookupJavaMethod(executable);
                access.requireAnalysisIteration();
                this.registerTypesForMethod(access, (AnalysisMethod)analysisElement, executable);
            }
            if (analysisElement == null) continue;
            this.processedHeapReflectionObjects.put(object, (AnalysisElement)analysisElement);
        }
        for (AnalysisElement processedObject : this.processedHeapReflectionObjects.values()) {
            if (processedObject instanceof AnalysisField) {
                analysisField = (AnalysisField)processedObject;
                this.registerHidingSubTypeFields(access, analysisField, analysisField.getDeclaringClass());
                continue;
            }
            if (!(processedObject instanceof AnalysisMethod)) continue;
            analysisMethod = (AnalysisMethod)processedObject;
            this.registerHidingSubTypeMethods(access, analysisMethod, analysisMethod.getDeclaringClass());
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (AnalysisField field : access.getUniverse().getFields()) {
                if (!field.isAccessed()) continue;
                ReflectionDataBuilder.registerTypesForReachableField(access, field);
            }
            for (Executable method : access.getUniverse().getMethods()) {
                if (!method.isReachable() || method.isIntrinsicMethod()) continue;
                ReflectionDataBuilder.registerTypesForReachableMethod(access, (AnalysisMethod)method);
            }
        }
    }

    private void registerHidingSubTypeFields(Feature.DuringAnalysisAccess access, AnalysisField field, AnalysisType type) {
        if (!(type.equals((Object)field.getDeclaringClass()) || !type.isReachable() || this.processedHidingFields.containsKey(field) && this.processedHidingFields.get(field).contains(type))) {
            this.processedHidingFields.computeIfAbsent(field, m -> ConcurrentHashMap.newKeySet()).add(type);
            try {
                AnalysisField[] subClassFields;
                for (AnalysisField subclassField : subClassFields = field.isStatic() ? type.getStaticFields() : type.getInstanceFields(false)) {
                    if (!subclassField.getName().equals(field.getName())) continue;
                    this.hidingFields.add(subclassField);
                }
                access.requireAnalysisIteration();
            }
            catch (UnsupportedFeatureException | LinkageError throwable) {
                // empty catch block
            }
        }
        for (AnalysisType subType : type.getSubTypes()) {
            if (subType.equals((Object)type)) continue;
            this.registerHidingSubTypeFields(access, field, subType);
        }
    }

    private void registerHidingSubTypeMethods(Feature.DuringAnalysisAccess access, AnalysisMethod method, AnalysisType type) {
        if (!(type.equals((Object)method.getDeclaringClass()) || !type.isReachable() || this.processedHidingMethods.containsKey(method) && this.processedHidingMethods.get(method).contains(type))) {
            this.processedHidingMethods.computeIfAbsent(method, m -> ConcurrentHashMap.newKeySet()).add(type);
            try {
                AnalysisMethod subClassMethod = type.findMethod(method.getName(), (Signature)method.getSignature());
                if (subClassMethod != null) {
                    this.hidingMethods.add(subClassMethod);
                }
                access.requireAnalysisIteration();
            }
            catch (UnsupportedFeatureException | LinkageError throwable) {
                // empty catch block
            }
        }
        for (AnalysisType subType : type.getSubTypes()) {
            if (subType.equals((Object)type)) continue;
            this.registerHidingSubTypeMethods(access, method, subType);
        }
    }

    private void registerTypesForClass(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType analysisType, Class<?> clazz) {
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(clazz::getTypeParameters));
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(clazz::getGenericSuperclass));
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(clazz::getGenericInterfaces));
        this.registerTypesForEnclosingMethodInfo(access, clazz);
        Object[] recordComponents = this.buildRecordComponents(clazz, access);
        if (recordComponents != null) {
            for (Object recordComponent : recordComponents) {
                this.registerTypesForRecordComponent(access, recordComponent);
            }
            this.registeredRecordComponents.put(clazz, recordComponents);
        }
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisType);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisType);
    }

    private void registerTypesForEnclosingMethodInfo(FeatureImpl.DuringAnalysisAccessImpl access, Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Object[] enclosingMethodInfo = this.getEnclosingMethodInfo(clazz);
        if (enclosingMethodInfo == null) {
            return;
        }
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, access.getMetaAccess().lookupJavaType((Class)enclosingMethodInfo[0]));
        try {
            enclosingMethodOrConstructor = Optional.ofNullable(clazz.getEnclosingMethod()).orElse((Method)((Object)clazz.getEnclosingConstructor()));
        }
        catch (InternalError | LinkageError | TypeNotPresentException e) {
            return;
        }
        if (enclosingMethodOrConstructor != null) {
            RuntimeReflection.registerAsQueried((Executable[])new Executable[]{enclosingMethodOrConstructor});
            access.requireAnalysisIteration();
        }
    }

    private Object[] getEnclosingMethodInfo(Class<?> clazz) {
        try {
            return (Object[])this.getEnclosingMethod0.invoke(clazz, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                return null;
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void registerTypesForField(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisField analysisField, Field reflectField) {
        access.registerAsUnsafeAccessed(analysisField);
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(reflectField::getGenericType));
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisField);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisField);
    }

    private void registerTypesForMethod(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod analysisMethod, Executable reflectMethod) {
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(reflectMethod::getTypeParameters));
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(reflectMethod::getGenericParameterTypes));
        this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(reflectMethod::getGenericExceptionTypes));
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(((Method)reflectMethod)::getGenericReturnType));
        }
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisMethod);
        this.registerTypesForParameterAnnotations(access, analysisMethod);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisMethod);
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForAnnotationDefault(access, analysisMethod);
        }
    }

    private static void registerTypesForReachableField(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisField analysisField) {
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisField.getDeclaringClass());
    }

    private static void registerTypesForReachableMethod(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod analysisMethod) {
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisMethod.getDeclaringClass());
        for (JavaType paramType : analysisMethod.toParameterTypes()) {
            ReflectionDataBuilder.makeAnalysisTypeReachable(access, (AnalysisType)paramType);
        }
    }

    private void registerTypesForGenericSignature(FeatureImpl.DuringAnalysisAccessImpl access, Type[] types) {
        this.registerTypesForGenericSignature(access, types, 0);
    }

    private void registerTypesForGenericSignature(FeatureImpl.DuringAnalysisAccessImpl access, Type[] types, int dimension) {
        if (types != null) {
            for (Type type : types) {
                this.registerTypesForGenericSignature(access, type, dimension);
            }
        }
    }

    private void registerTypesForGenericSignature(FeatureImpl.DuringAnalysisAccessImpl access, Type type) {
        this.registerTypesForGenericSignature(access, type, 0);
    }

    private void registerTypesForGenericSignature(FeatureImpl.DuringAnalysisAccessImpl access, Type type, int dimension) {
        if (type == null) {
            return;
        }
        try {
            if (this.processedTypes.getOrDefault(type, -1) >= dimension) {
                return;
            }
            this.processedTypes.put(type, dimension);
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException throwable) {
            // empty catch block
        }
        if (type instanceof Class && !SubstitutionReflectivityFilter.shouldExclude((Class)type, access.getMetaAccess(), access.getUniverse())) {
            Class clazz = (Class)type;
            if (dimension > 0) {
                ReflectionDataBuilder.makeAnalysisTypeReachable(access, access.getMetaAccess().lookupJavaType(clazz).getArrayClass(dimension));
            }
            ClassForNameSupport.registerClass(clazz);
        } else if (type instanceof TypeVariable) {
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(((TypeVariable)type)::getBounds), dimension);
        } else if (type instanceof GenericArrayType) {
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(((GenericArrayType)type)::getGenericComponentType), dimension + 1);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(parameterizedType::getActualTypeArguments));
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(parameterizedType::getRawType), dimension);
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(parameterizedType::getOwnerType));
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(wildcardType::getLowerBounds), dimension);
            this.registerTypesForGenericSignature(access, ReflectionDataBuilder.queryGenericInfo(wildcardType::getUpperBounds), dimension);
        }
    }

    private void registerTypesForRecordComponent(FeatureImpl.DuringAnalysisAccessImpl access, Object recordComponent) {
        this.registerTypesForAnnotations(access, (AnnotatedElement)recordComponent);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)recordComponent);
    }

    private void registerTypesForAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            this.filteredAnnotations.computeIfAbsent(annotatedElement, element -> {
                ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                for (AnnotationValue annotation : this.annotationExtracter.getDeclaredAnnotationData((AnnotatedElement)element)) {
                    if (!ReflectionDataBuilder.includeAnnotation(access, annotation)) continue;
                    includedAnnotations.add(annotation);
                    ReflectionDataBuilder.registerTypes(access, annotation.getTypes());
                }
                return includedAnnotations.toArray(new AnnotationValue[0]);
            });
        }
    }

    private void registerTypesForParameterAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod executable) {
        if (executable != null) {
            this.filteredParameterAnnotations.computeIfAbsent(executable, element -> {
                AnnotationValue[][] parameterAnnotations = this.annotationExtracter.getParameterAnnotationData((AnnotatedElement)element);
                AnnotationValue[][] includedParameterAnnotations = new AnnotationValue[parameterAnnotations.length][];
                for (int i = 0; i < includedParameterAnnotations.length; ++i) {
                    AnnotationValue[] annotations = parameterAnnotations[i];
                    ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                    for (AnnotationValue annotation : annotations) {
                        if (!ReflectionDataBuilder.includeAnnotation(access, annotation)) continue;
                        includedAnnotations.add(annotation);
                        ReflectionDataBuilder.registerTypes(access, annotation.getTypes());
                    }
                    includedParameterAnnotations[i] = includedAnnotations.toArray(new AnnotationValue[0]);
                }
                return includedParameterAnnotations;
            });
        }
    }

    private void registerTypesForTypeAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            this.filteredTypeAnnotations.computeIfAbsent(annotatedElement, element -> {
                ArrayList<TypeAnnotationValue> includedTypeAnnotations = new ArrayList<TypeAnnotationValue>();
                for (TypeAnnotationValue typeAnnotation : this.annotationExtracter.getTypeAnnotationData((AnnotatedElement)element)) {
                    if (!ReflectionDataBuilder.includeAnnotation(access, typeAnnotation.getAnnotationData())) continue;
                    includedTypeAnnotations.add(typeAnnotation);
                    ReflectionDataBuilder.registerTypes(access, typeAnnotation.getAnnotationData().getTypes());
                }
                return includedTypeAnnotations.toArray(new TypeAnnotationValue[0]);
            });
        }
    }

    private void registerTypesForAnnotationDefault(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.annotationExtracter.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            ReflectionDataBuilder.registerTypes(access, annotationDefault.getTypes());
        }
    }

    private static boolean includeAnnotation(FeatureImpl.DuringAnalysisAccessImpl access, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return false;
        }
        for (Class<?> type : annotationValue.getTypes()) {
            if (type != null && !SubstitutionReflectivityFilter.shouldExclude(type, access.getMetaAccess(), access.getUniverse())) continue;
            return false;
        }
        return true;
    }

    private static void registerTypes(FeatureImpl.DuringAnalysisAccessImpl access, Collection<Class<?>> types) {
        for (Class<?> type : types) {
            AnalysisType analysisType = access.getMetaAccess().lookupJavaType(type);
            ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisType);
            if (type.isAnnotation()) {
                RuntimeProxyCreation.register((Class[])new Class[]{type});
            }
            if (!ExceptionProxy.class.isAssignableFrom(type)) continue;
            analysisType.registerAsInHeap();
        }
    }

    private static void makeAnalysisTypeReachable(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type) {
        if (type.registerAsReachable()) {
            access.requireAnalysisIteration();
        }
    }

    private void processRegisteredElements(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (!this.modifiedClasses.isEmpty()) {
            for (Class<?> clazz : this.modifiedClasses) {
                this.processClass(access, clazz);
            }
            this.modifiedClasses.clear();
            access.requireAnalysisIteration();
        }
        if (!this.inaccessibleClasses.isEmpty()) {
            this.inaccessibleClasses.forEach(ClassLoadingExceptionSupport::registerClass);
            this.inaccessibleClasses.clear();
            access.requireAnalysisIteration();
        }
    }

    private void processClass(FeatureImpl.DuringAnalysisAccessImpl access, Class<?> clazz) {
        if (SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
        type.registerAsReachable();
        if (this.unsafeInstantiatedClasses.contains(clazz)) {
            type.registerAsAllocated(null);
        }
        if (this.reflectionClasses.contains(clazz)) {
            ClassForNameSupport.registerClass(clazz);
            try {
                if (clazz.getEnclosingClass() != null) {
                    this.innerClasses.computeIfAbsent(access.getMetaAccess().lookupJavaType(clazz.getEnclosingClass()).getJavaClass(), enclosingType -> ConcurrentHashMap.newKeySet()).add(clazz);
                }
            }
            catch (LinkageError e) {
                ReflectionDataBuilder.reportLinkingErrors(clazz, List.of(e));
            }
        }
        if (type.isAnnotation()) {
            HashSet<AccessibleObject> members = new HashSet<AccessibleObject>();
            for (Field field : this.reflectionFields) {
                if (!field.getDeclaringClass().equals(clazz) || SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) continue;
                members.add(field);
            }
            for (Executable executable : this.reflectionMethods.keySet()) {
                if (!executable.getDeclaringClass().equals(clazz) || SubstitutionReflectivityFilter.shouldExclude(executable, access.getMetaAccess(), access.getUniverse())) continue;
                members.add(executable);
            }
            this.annotationMembers.put(clazz, members);
            access.requireAnalysisIteration();
        }
    }

    private static <T> T queryGenericInfo(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException e) {
            return null;
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
    }

    private Object[] buildRecordComponents(Class<?> clazz, FeatureImpl.DuringAnalysisAccessImpl access) {
        Method[] allMethods;
        RecordSupport support = RecordSupport.singleton();
        if (!support.isRecord(clazz)) {
            return null;
        }
        for (Method method : allMethods = support.getRecordComponentAccessorMethods(clazz)) {
            if (this.reflectionMethods.containsKey(method) && !SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            return null;
        }
        return support.getRecordComponents(clazz);
    }

    private static void reportLinkingErrors(Class<?> clazz, List<Throwable> errors) {
        if (errors.isEmpty()) {
            return;
        }
        String messages = errors.stream().map(e -> e.getClass().getTypeName() + ": " + e.getMessage()).distinct().collect(Collectors.joining(", "));
        System.out.println("Warning: Could not register complete reflection metadata for " + clazz.getTypeName() + ". Reason(s): " + messages);
    }

    protected void afterAnalysis() {
        this.sealed = true;
        if (!this.modifiedClasses.isEmpty()) {
            throw UserError.abort("Registration of classes, methods, and fields for reflective access during analysis must set DuringAnalysisAccess.requireAnalysisIteration().", new Object[0]);
        }
    }

    @Override
    public boolean requiresProcessing() {
        return !this.modifiedClasses.isEmpty();
    }

    @Override
    public Map<Class<?>, Set<Class<?>>> getReflectionInnerClasses() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.innerClasses);
    }

    @Override
    public Set<Field> getReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.registeredFields.keySet());
    }

    @Override
    public Set<Executable> getReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.registeredMethods.keySet());
    }

    @Override
    public Object getAccessor(Executable method) {
        assert (this.sealed);
        return this.methodAccessors.get(method);
    }

    public Set<ResolvedJavaField> getHidingReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingFields);
    }

    public Set<ResolvedJavaMethod> getHidingReflectionMethods() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingMethods);
    }

    @Override
    public Object[] getRecordComponents(Class<?> type) {
        assert (this.sealed);
        return this.registeredRecordComponents.get(type);
    }

    @Override
    public void registerHeapDynamicHub(Object hub) {
        assert (!this.sealed);
        this.heapDynamicHubs.add((DynamicHub)hub);
    }

    public Set<DynamicHub> getHeapDynamicHubs() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapDynamicHubs);
    }

    @Override
    public void registerHeapReflectionObject(AccessibleObject object) {
        assert (!this.sealed);
        this.heapReflectionObjects.add(object);
    }

    @Override
    public Set<AccessibleObject> getHeapReflectionObjects() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapReflectionObjects);
    }

    public AnnotationValue[] getAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredAnnotations.getOrDefault(element, NO_ANNOTATIONS);
    }

    public AnnotationValue[][] getParameterAnnotationData(AnalysisMethod element) {
        assert (this.sealed);
        return this.filteredParameterAnnotations.getOrDefault(element, NO_PARAMETER_ANNOTATIONS);
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredTypeAnnotations.getOrDefault(element, NO_TYPE_ANNOTATIONS);
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        return this.annotationExtracter.getAnnotationDefaultData(element);
    }

    @Override
    public int getReflectionClassesCount() {
        return this.reflectionClasses.size();
    }

    @Override
    public int getReflectionMethodsCount() {
        return this.registeredMethods.size();
    }

    @Override
    public int getReflectionFieldsCount() {
        return this.registeredFields.size();
    }

    private static enum ExecutableAccessibility {
        QueriedOnly,
        Accessed;


        static ExecutableAccessibility max(ExecutableAccessibility a, ExecutableAccessibility b) {
            return a == Accessed || b == Accessed ? Accessed : QueriedOnly;
        }
    }
}

