/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.Hybrid;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.heap.PodFactorySubstitutionProcessor;
import com.oracle.svm.hosted.heap.PodSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class PodFeature
implements PodSupport,
InternalFeature {
    private static final AtomicInteger GENERATED_COUNTER = new AtomicInteger();
    private final Map<Pod.RuntimeSupport.PodSpec, Pod.RuntimeSupport.PodInfo> pods = new ConcurrentHashMap<Pod.RuntimeSupport.PodSpec, Pod.RuntimeSupport.PodInfo>();
    private final Set<Class<?>> classesNeedingLengthFields = ConcurrentHashMap.newKeySet();
    private Feature.BeforeAnalysisAccess analysisAccess;
    private volatile boolean instantiated = false;
    private boolean sealed = false;

    PodFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PodSupport.class, (Object)this);
        ImageSingletons.add(Pod.RuntimeSupport.class, (Object)new Pod.RuntimeSupport());
        this.registerSuperclass(Object.class, Supplier.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((FeatureImpl.DuringSetupAccessImpl)access).registerSubstitutionProcessor(new PodFactorySubstitutionProcessor());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.analysisAccess = access;
        access.registerReachabilityHandler(this::registerAsInstantiated, (Object[])Pod.Builder.class.getDeclaredConstructors());
    }

    private void registerAsInstantiated(Feature.DuringAnalysisAccess access) {
        this.instantiated = true;
        this.pods.forEach((spec, podInfo) -> PodFeature.registerPodAsInstantiated((Feature.BeforeAnalysisAccess)access, spec, podInfo));
    }

    private static void registerPodAsInstantiated(Feature.BeforeAnalysisAccess access, Pod.RuntimeSupport.PodSpec spec, Pod.RuntimeSupport.PodInfo info) {
        access.registerAsInHeap(info.podClass);
        Pod.RuntimeSupport.singleton().registerPod(spec, info);
    }

    @Override
    public void registerSuperclass(Class<?> superClass, Class<?> factoryInterface) {
        Constructor<?> factoryCtor;
        if (this.sealed) {
            throw UserError.abort("Pod superclasses can not be registered after analysis has finished", new Object[0]);
        }
        if (superClass == null || factoryInterface == null) {
            throw new NullPointerException();
        }
        Pod.RuntimeSupport.PodSpec spec = new Pod.RuntimeSupport.PodSpec(superClass, factoryInterface);
        if (this.pods.containsKey(spec)) {
            return;
        }
        if (!factoryInterface.isInterface()) {
            throw new IllegalArgumentException("Factory is not an interface: " + factoryInterface);
        }
        for (Method method : factoryInterface.getMethods()) {
            if (!method.getReturnType().isAssignableFrom(superClass)) {
                throw new IllegalArgumentException("The return type of '" + method + "' is not assignable from '" + superClass.getName() + "'");
            }
            try {
                superClass.getDeclaredConstructor(method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Method '" + method + "' does not match any constructor in '" + superClass.getName() + "'", e);
            }
        }
        Class<?> podClass = PodFeature.generatePodClass(superClass);
        Pod.RuntimeSupport.PodInfo info = new Pod.RuntimeSupport.PodInfo(podClass, factoryCtor = PodFeature.generatePodFactory(podClass, factoryInterface));
        if (this.pods.putIfAbsent(spec, info) != null) {
            return;
        }
        if (this.instantiated) {
            PodFeature.registerPodAsInstantiated(this.analysisAccess, spec, info);
        }
        Class<?> sup = podClass;
        while (sup.getSuperclass() != Object.class) {
            sup = sup.getSuperclass();
        }
        this.classesNeedingLengthFields.add(sup);
    }

    private static Class<?> generatePodClass(Class<?> superClass) {
        String className = Pod.class.getName() + "$$Generated" + GENERATED_COUNTER.incrementAndGet();
        ClassWriter writer = new ClassWriter(0);
        int access = 4145;
        writer.visit(55, access, className.replace('.', '/'), null, Type.getInternalName(superClass), null);
        AnnotationVisitor annotation = writer.visitAnnotation(Type.getDescriptor(Hybrid.class), true);
        annotation.visit("componentType", Type.getType(Byte.TYPE));
        annotation.visitEnd();
        writer.visitEnd();
        byte[] data = writer.toByteArray();
        Class<?> podClass = NativeImageSystemClassLoader.singleton().predefineClass(className, data, 0, data.length);
        assert (podClass.getSuperclass() == superClass);
        return podClass;
    }

    private static Constructor<?> generatePodFactory(Class<?> podClass, Class<?> factoryInterface) {
        String name = Pod.class.getName() + "$$GeneratedFactory" + GENERATED_COUNTER.incrementAndGet();
        String internalName = name.replace('.', '/');
        String podDescriptor = Type.getDescriptor(Pod.class);
        ClassWriter writer = new ClassWriter(0);
        int access = 4145;
        writer.visit(55, access, internalName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(factoryInterface)});
        AnnotationVisitor annotation = writer.visitAnnotation(Type.getDescriptor(Pod.RuntimeSupport.PodFactory.class), true);
        annotation.visit("podClass", Type.getType(podClass));
        annotation.visitEnd();
        writer.visitField(4114, "pod", podDescriptor, null, null).visitEnd();
        MethodVisitor init = writer.visitMethod(4097, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(podDescriptor)), null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        init.visitVarInsn(25, 0);
        init.visitVarInsn(25, 1);
        init.visitFieldInsn(181, internalName, "pod", podDescriptor);
        init.visitInsn(177);
        init.visitMaxs(2, 2);
        init.visitEnd();
        for (Method method : factoryInterface.getMethods()) {
            int methodAccess = 4113;
            MethodVisitor impl = writer.visitMethod(methodAccess, method.getName(), Type.getMethodDescriptor(method), null, null);
            if (method.isAnnotationPresent(DeoptTest.class)) {
                impl.visitAnnotation(Type.getDescriptor(DeoptTest.class), true).visitEnd();
            }
            impl.visitCode();
            impl.visitInsn(1);
            impl.visitInsn(176);
            int localSlots = 1;
            for (Class<?> clazz : method.getParameterTypes()) {
                localSlots += JavaKind.fromJavaClass(clazz).getSlotCount();
            }
            impl.visitMaxs(1, localSlots);
            impl.visitEnd();
        }
        writer.visitEnd();
        byte[] data = writer.toByteArray();
        Class<?> factoryClass = NativeImageSystemClassLoader.singleton().predefineClass(name, data, 0, data.length);
        assert (factoryInterface.isAssignableFrom(factoryClass));
        return ReflectionUtil.lookupConstructor(factoryClass, (Class[])new Class[]{Pod.class});
    }

    @Override
    public boolean isPodClass(Class<?> clazz) {
        if ((clazz.getModifiers() & 0x1000) != 0 && clazz.isAnnotationPresent(Hybrid.class)) {
            for (Pod.RuntimeSupport.PodInfo info : this.pods.values()) {
                if (info.podClass != clazz) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mustReserveLengthField(Class<?> clazz) {
        return this.classesNeedingLengthFields.contains(clazz);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisAccess = null;
        this.sealed = true;
    }
}

