/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.stubs;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.graal.stubs.SVMIntrinsicStubsGen;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class, Platform.AARCH64.class})
public class StubForeignCallsFeatureBase
implements InternalFeature {
    private final StubDescriptor[] stubDescriptors;

    protected StubForeignCallsFeatureBase(StubDescriptor[] stubDescriptors) {
        this.stubDescriptors = stubDescriptors;
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !SubstrateOptions.useLLVMBackend();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        for (StubDescriptor sd : this.stubDescriptors) {
            StubForeignCallsFeatureBase.registerStubRoots(access, sd.getStubs());
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        for (StubDescriptor sd : this.stubDescriptors) {
            foreignCalls.register(sd.getStubs());
        }
    }

    private static void registerStubRoots(Feature.BeforeAnalysisAccess access, SnippetRuntime.SubstrateForeignCallDescriptor[] foreignCalls) {
        FeatureImpl.BeforeAnalysisAccessImpl impl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        AnalysisMetaAccess metaAccess = impl.getMetaAccess();
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : foreignCalls) {
            AnalysisMethod method = (AnalysisMethod)descriptor.findMethod((MetaAccessProvider)metaAccess);
            impl.registerAsRoot(method, true);
        }
    }

    private static EnumSet<?> getBuildtimeFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures();
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures();
        }
        throw GraalError.shouldNotReachHere();
    }

    static final class StubDescriptor {
        private final ForeignCallDescriptor[] foreignCallDescriptors;
        private final boolean isReexecutable;
        private final EnumSet<?> minimumRequiredFeatures;
        private final EnumSet<?> runtimeCheckedCPUFeatures;
        private SnippetRuntime.SubstrateForeignCallDescriptor[] stubs;

        StubDescriptor(ForeignCallDescriptor foreignCallDescriptors, boolean isReexecutable, EnumSet<?> minimumRequiredFeatures, EnumSet<?> runtimeCheckedCPUFeatures) {
            this(new ForeignCallDescriptor[]{foreignCallDescriptors}, isReexecutable, minimumRequiredFeatures, runtimeCheckedCPUFeatures);
        }

        StubDescriptor(ForeignCallDescriptor[] foreignCallDescriptors, boolean isReexecutable, EnumSet<?> minimumRequiredFeatures, EnumSet<?> runtimeCheckedCPUFeatures) {
            this.foreignCallDescriptors = foreignCallDescriptors;
            this.isReexecutable = isReexecutable;
            this.minimumRequiredFeatures = minimumRequiredFeatures;
            this.runtimeCheckedCPUFeatures = runtimeCheckedCPUFeatures;
        }

        private SnippetRuntime.SubstrateForeignCallDescriptor[] getStubs() {
            if (this.stubs == null) {
                this.stubs = this.mapStubs();
            }
            return this.stubs;
        }

        private SnippetRuntime.SubstrateForeignCallDescriptor[] mapStubs() {
            EnumSet<?> buildtimeCPUFeatures = StubForeignCallsFeatureBase.getBuildtimeFeatures();
            boolean isJITCompilationEnabled = DeoptimizationSupport.enabled();
            boolean generateBaseline = buildtimeCPUFeatures.containsAll(this.minimumRequiredFeatures) || isJITCompilationEnabled && !this.minimumRequiredFeatures.equals(this.runtimeCheckedCPUFeatures);
            boolean generateRuntimeChecked = !buildtimeCPUFeatures.containsAll(this.runtimeCheckedCPUFeatures) && isJITCompilationEnabled;
            ArrayList<SnippetRuntime.SubstrateForeignCallDescriptor> ret = new ArrayList<SnippetRuntime.SubstrateForeignCallDescriptor>();
            for (ForeignCallDescriptor call : this.foreignCallDescriptors) {
                if (generateBaseline) {
                    ret.add(SnippetRuntime.findForeignCall(SVMIntrinsicStubsGen.class, call.getName(), this.isReexecutable, new LocationIdentity[0]));
                }
                if (!generateRuntimeChecked) continue;
                ret.add(SnippetRuntime.findForeignCall(SVMIntrinsicStubsGen.class, call.getName() + "RTC", this.isReexecutable, new LocationIdentity[0]));
            }
            return ret.toArray(new SnippetRuntime.SubstrateForeignCallDescriptor[0]);
        }
    }
}

