/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.engine.test.InternalFlowableIdmExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PluggableFlowableIdmExtension
extends InternalFlowableIdmExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PluggableFlowableIdmExtension.class});
    private static final String IDM_ENGINE = "cachedIdmEngine";

    @Override
    protected IdmEngine getIdmEngine(ExtensionContext context) {
        return (IdmEngine)this.getStore(context).getOrComputeIfAbsent((Object)IDM_ENGINE, key -> this.initializeIdmEngine(), IdmEngine.class);
    }

    protected IdmEngine initializeIdmEngine() {
        this.logger.info("No cached idm engine found for test. Retrieving the default engine.");
        IdmEngines.destroy();
        IdmEngine idmEngine = IdmEngines.getDefaultIdmEngine();
        if (idmEngine == null) {
            throw new FlowableException("no default idm engine available");
        }
        return idmEngine;
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

