/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.idm.api.IdmManagementService;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.util.CommandContextUtil;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableIdmExtension
implements AfterEachCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver {
    protected static final String EMPTY_LINE = "\n";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_METHOD);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFinally(ExtensionContext context, TestInstance.Lifecycle lifecycleForClean) {
        IdmEngine idmEngine = this.getIdmEngine(context);
        IdmEngineConfiguration idmEngineConfiguration = idmEngine.getIdmEngineConfiguration();
        try {
            if (context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == lifecycleForClean) {
                this.cleanTestAndAssertAndEnsureCleanDb(context, idmEngine);
            }
        }
        finally {
            idmEngineConfiguration.getClock().reset();
        }
    }

    protected void cleanTestAndAssertAndEnsureCleanDb(ExtensionContext context, IdmEngine idmEngine) {
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> this.assertAndEnsureCleanDb(idmEngine, context, (EnsureCleanDb)ensureCleanDb));
    }

    protected void assertAndEnsureCleanDb(IdmEngine idmEngine, ExtensionContext context, EnsureCleanDb ensureCleanDb) {
        this.logger.debug("verifying that db is clean after test");
        HashSet<String> tableNamesExcludedFromDbCleanCheck = new HashSet<String>(Arrays.asList(ensureCleanDb.excludeTables()));
        IdmManagementService managementService = idmEngine.getIdmManagementService();
        IdmEngineConfiguration idmEngineConfiguration = idmEngine.getIdmEngineConfiguration();
        Map tableCounts = managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(idmEngineConfiguration.getDatabaseTablePrefix(), "");
            if (tableNamesExcludedFromDbCleanCheck.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            this.logger.error(EMPTY_LINE);
            this.logger.error(outputMessage.toString());
            this.logger.info("dropping and recreating db");
            if (ensureCleanDb.dropDb()) {
                CommandExecutor commandExecutor = idmEngineConfiguration.getCommandExecutor();
                CommandConfig config = new CommandConfig().transactionNotSupported();
                commandExecutor.execute(config, (Command)new Command<Object>(){

                    public Object execute(CommandContext commandContext) {
                        SchemaManager schemaManager = CommandContextUtil.getIdmEngineConfiguration(commandContext).getSchemaManager();
                        schemaManager.schemaDrop();
                        schemaManager.schemaCreate();
                        return null;
                    }
                });
            }
            if (!context.getExecutionException().isPresent()) {
                throw new AssertionError((Object)outputMessage.toString());
            }
        } else {
            this.logger.info("database was clean");
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return IdmEngine.class.equals(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        return this.getIdmEngine(context);
    }

    protected abstract IdmEngine getIdmEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

