/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.HashMap;
import java.util.Map;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdmTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdmTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, IdmEngine> idmEngines = new HashMap<String, IdmEngine>();

    public static IdmEngine getIdmEngine(String configurationResource) {
        IdmEngine idmEngine = idmEngines.get(configurationResource);
        if (idmEngine == null) {
            LOGGER.debug("==== BUILDING IDM ENGINE ========================================================================");
            idmEngine = IdmEngineConfiguration.createIdmEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("drop-create").buildIdmEngine();
            LOGGER.debug("==== IDM ENGINE CREATED =========================================================================");
            idmEngines.put(configurationResource, idmEngine);
        }
        return idmEngine;
    }

    public static void closeIdmEngines() {
        for (IdmEngine idmEngine : idmEngines.values()) {
            idmEngine.close();
        }
        idmEngines.clear();
    }
}

