/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.keydetector;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.eventregistry.api.InboundEventKeyDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPointerBasedInboundEventKeyDetector
implements InboundEventKeyDetector<JsonNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPointerBasedInboundEventKeyDetector.class);
    protected ObjectMapper objectMapper;
    protected String jsonPointerValue;
    protected JsonPointer jsonPointerExpression;

    public JsonPointerBasedInboundEventKeyDetector(String jsonPointerExpression, ObjectMapper objectMapper) {
        this.jsonPointerValue = jsonPointerExpression;
        this.jsonPointerExpression = JsonPointer.compile((String)jsonPointerExpression);
        this.objectMapper = objectMapper;
    }

    public String detectEventDefinitionKey(JsonNode payload) {
        JsonNode result = payload.at(this.jsonPointerExpression);
        if (result == null || result.isMissingNode() || result.isNull()) {
            LOGGER.warn("JsonPointer expression {} did not detect event key", (Object)this.jsonPointerExpression);
            return null;
        }
        if (result.isTextual()) {
            return result.asText();
        }
        return null;
    }

    public String getJsonPointerValue() {
        return this.jsonPointerValue;
    }
}

