/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.impl.deployer.ParsedDeployment;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class EventDefinitionDeploymentHelper {
    public void verifyEventDefinitionsDoNotShareKeys(Collection<EventDefinitionEntity> eventDefinitions) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (EventDefinitionEntity eventDefinition : eventDefinitions) {
            if (keySet.contains(eventDefinition.getKey())) {
                throw new FlowableException("The deployment contains event definition with the same key, this is not allowed");
            }
            keySet.add(eventDefinition.getKey());
        }
    }

    public void copyDeploymentValuesToEventDefinitions(EventDeploymentEntity deployment, List<EventDefinitionEntity> eventDefinitions) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (EventDefinitionEntity eventDefinition : eventDefinitions) {
            if (tenantId != null) {
                eventDefinition.setTenantId(tenantId);
            }
            eventDefinition.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnEventDefinitions(ParsedDeployment parsedDeployment) {
        for (EventDefinitionEntity eventDefinition : parsedDeployment.getAllEventDefinitions()) {
            String resourceName = parsedDeployment.getResourceForEventDefinition(eventDefinition).getName();
            eventDefinition.setResourceName(resourceName);
        }
    }

    public EventDefinitionEntity getMostRecentVersionOfEventDefinition(EventDefinitionEntity eventDefinition) {
        String key = eventDefinition.getKey();
        String tenantId = eventDefinition.getTenantId();
        EventDefinitionEntityManager eventDefinitionEntityManager = CommandContextUtil.getEventRegistryConfiguration().getEventDefinitionEntityManager();
        EventDefinitionEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? eventDefinitionEntityManager.findLatestEventDefinitionByKeyAndTenantId(key, tenantId) : eventDefinitionEntityManager.findLatestEventDefinitionByKey(key);
        return existingDefinition;
    }

    public EventDefinitionEntity getPersistedInstanceOfEventDefinition(EventDefinitionEntity eventDefinition) {
        String deploymentId = eventDefinition.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)eventDefinition.getDeploymentId())) {
            throw new FlowableIllegalArgumentException("Provided event definition must have a deployment id.");
        }
        EventDefinitionEntityManager eventDefinitionEntityManager = CommandContextUtil.getEventRegistryConfiguration().getEventDefinitionEntityManager();
        EventDefinitionEntity persistedEventDefinition = null;
        persistedEventDefinition = eventDefinition.getTenantId() == null || "".equals(eventDefinition.getTenantId()) ? eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKey(deploymentId, eventDefinition.getKey()) : eventDefinitionEntityManager.findEventDefinitionByDeploymentAndKeyAndTenantId(deploymentId, eventDefinition.getKey(), eventDefinition.getTenantId());
        return persistedEventDefinition;
    }
}

