/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.qrcode.render;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import org.dromara.hutool.swing.img.Img;
import org.dromara.hutool.swing.img.ImgUtil;
import org.dromara.hutool.swing.qrcode.QrConfig;
import org.dromara.hutool.swing.qrcode.render.BitMatrixRender;

public class ImageRender
implements BitMatrixRender {
    private final QrConfig config;
    private final String imageType;

    public ImageRender(QrConfig config, String imageType) {
        this.config = config;
        this.imageType = imageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(BitMatrix matrix, OutputStream out) {
        BufferedImage img = null;
        try {
            img = this.render(matrix);
            ImgUtil.write((Image)img, this.imageType, out);
        }
        finally {
            ImgUtil.flush(img);
        }
    }

    public BufferedImage render(BitMatrix matrix) {
        BufferedImage image = this.getBufferedImage(matrix);
        Image logo = this.config.getImg();
        if (null != logo && BarcodeFormat.QR_CODE == this.config.getFormat()) {
            this.pressLogo(image, logo);
        }
        return image;
    }

    private BufferedImage getBufferedImage(BitMatrix matrix) {
        BufferedImage image = new BufferedImage(matrix.getWidth(), matrix.getHeight(), null == this.config.getBackColor() ? 2 : 1);
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        Integer foreColor = this.config.getForeColor();
        Integer backColor = this.config.getBackColor();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    private void pressLogo(BufferedImage image, Image logoImg) {
        int imgHeight;
        int imgWidth;
        int qrHeight;
        int qrWidth = image.getWidth();
        if (qrWidth < (qrHeight = image.getHeight())) {
            imgWidth = qrWidth / this.config.getRatio();
            imgHeight = logoImg.getHeight(null) * imgWidth / logoImg.getWidth(null);
        } else {
            imgHeight = qrHeight / this.config.getRatio();
            imgWidth = logoImg.getWidth(null) * imgHeight / logoImg.getHeight(null);
        }
        Img.from(image).pressImage(Img.from(logoImg).round(this.config.getImgRound()).getImg(), new Rectangle(imgWidth, imgHeight), 1.0f);
    }
}

