/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="display-parent-updates", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class DisplayParentUpdatesMojo
extends AbstractVersionsDisplayMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactVersion artifactVersion;
        VersionRange versionRange;
        String currentVersion;
        this.logInit();
        if (this.getProject().getParent() == null) {
            this.logLine(false, "Project does not have a parent.");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.logLine(false, "Parent project is part of the reactor.");
            return;
        }
        String version = currentVersion = this.getProject().getParent().getVersion();
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(this.getProject().getParent().getGroupId(), this.getProject().getParent().getArtifactId(), versionRange, "pom", null, null);
        try {
            artifactVersion = this.findLatestVersion(artifact, versionRange, null, false);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (artifactVersion == null || currentVersion.equals(artifactVersion.toString())) {
            this.logLine(false, "The parent project is the latest version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - currentVersion.length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            this.logLine(false, buf.toString());
        } else {
            this.logLine(false, "The parent project has a newer version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - currentVersion.length() - artifactVersion.toString().length() - " -> ".length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            buf.append(" -> ");
            buf.append(artifactVersion);
            this.logLine(false, buf.toString());
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
    }
}

