/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ForkedJvm;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

class JTB
extends ToolFacade {
    private static final String SYNTAX_TREE = "syntaxtree";
    private static final String VISITOR = "visitor";
    private File inputFile;
    private File outputDirectory;
    private File nodeDirectory;
    private File visitorDirectory;
    private String packageName;
    private String nodePackageName;
    private String visitorPackageName;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;

    JTB() {
    }

    public void setInputFile(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.inputFile = value;
    }

    public void setOutputDirectory(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.outputDirectory = value;
    }

    public File getOutputFile() {
        File outputFile = null;
        if (this.outputDirectory != null && this.inputFile != null) {
            String fileName = FileUtils.removeExtension((String)this.inputFile.getName()) + ".jj";
            outputFile = new File(this.outputDirectory, fileName);
        }
        return outputFile;
    }

    public void setNodeDirectory(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.nodeDirectory = value;
    }

    private File getEffectiveNodeDirectory() {
        if (this.nodeDirectory != null) {
            return this.nodeDirectory;
        }
        if (this.outputDirectory != null) {
            return new File(this.outputDirectory, this.getLastPackageName(this.getEffectiveNodePackageName()));
        }
        return null;
    }

    public void setVisitorDirectory(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.visitorDirectory = value;
    }

    private File getEffectiveVisitorDirectory() {
        if (this.visitorDirectory != null) {
            return this.visitorDirectory;
        }
        if (this.outputDirectory != null) {
            return new File(this.outputDirectory, this.getLastPackageName(this.getEffectiveVisitorPackageName()));
        }
        return null;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public void setNodePackageName(String value) {
        this.nodePackageName = value;
    }

    private String getEffectiveNodePackageName() {
        if (this.packageName != null) {
            return this.packageName.length() <= 0 ? SYNTAX_TREE : this.packageName + '.' + SYNTAX_TREE;
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return SYNTAX_TREE;
    }

    public void setVisitorPackageName(String value) {
        this.visitorPackageName = value;
    }

    private String getEffectiveVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName.length() <= 0 ? VISITOR : this.packageName + '.' + VISITOR;
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return VISITOR;
    }

    public void setSupressErrorChecking(Boolean value) {
        this.supressErrorChecking = value;
    }

    public void setJavadocFriendlyComments(Boolean value) {
        this.javadocFriendlyComments = value;
    }

    public void setDescriptiveFieldNames(Boolean value) {
        this.descriptiveFieldNames = value;
    }

    public void setNodeParentClass(String value) {
        this.nodeParentClass = value;
    }

    public void setParentPointers(Boolean value) {
        this.parentPointers = value;
    }

    public void setSpecialTokens(Boolean value) {
        this.specialTokens = value;
    }

    public void setScheme(Boolean value) {
        this.scheme = value;
    }

    public void setPrinter(Boolean value) {
        this.printer = value;
    }

    protected int execute() throws Exception {
        String[] args = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        ForkedJvm jvm = new ForkedJvm();
        jvm.setMainClass("EDU.purdue.jtb.JTB");
        jvm.addArguments(args);
        jvm.setSystemOut(new MojoLogStreamConsumer(false));
        jvm.setSystemErr(new MojoLogStreamConsumer(true));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Forking: " + jvm));
        }
        int exitcode = jvm.run();
        this.moveJavaFiles();
        return exitcode;
    }

    private String[] generateArguments() {
        File outputFile;
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-np");
        argsList.add(this.getEffectiveNodePackageName());
        argsList.add("-vp");
        argsList.add(this.getEffectiveVisitorPackageName());
        if (this.supressErrorChecking != null && this.supressErrorChecking.booleanValue()) {
            argsList.add("-e");
        }
        if (this.javadocFriendlyComments != null && this.javadocFriendlyComments.booleanValue()) {
            argsList.add("-jd");
        }
        if (this.descriptiveFieldNames != null && this.descriptiveFieldNames.booleanValue()) {
            argsList.add("-f");
        }
        if (this.nodeParentClass != null) {
            argsList.add("-ns");
            argsList.add(this.nodeParentClass);
        }
        if (this.parentPointers != null && this.parentPointers.booleanValue()) {
            argsList.add("-pp");
        }
        if (this.specialTokens != null && this.specialTokens.booleanValue()) {
            argsList.add("-tk");
        }
        if (this.scheme != null && this.scheme.booleanValue()) {
            argsList.add("-scheme");
        }
        if (this.printer != null && this.printer.booleanValue()) {
            argsList.add("-printer");
        }
        if ((outputFile = this.getOutputFile()) != null) {
            argsList.add("-o");
            argsList.add(outputFile.getAbsolutePath());
        }
        if (this.inputFile != null) {
            argsList.add(this.inputFile.getAbsolutePath());
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    private String getLastPackageName(String name) {
        if (name != null) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return null;
    }

    private void moveJavaFiles() throws IOException {
        File nodeSrcDir = new File(this.getLastPackageName(this.getEffectiveNodePackageName())).getAbsoluteFile();
        File nodeDstDir = this.getEffectiveNodeDirectory();
        this.moveDirectory(nodeSrcDir, nodeDstDir);
        File visitorSrcDir = new File(this.getLastPackageName(this.getEffectiveVisitorPackageName())).getAbsoluteFile();
        File visitorDstDir = this.getEffectiveVisitorDirectory();
        this.moveDirectory(visitorSrcDir, visitorDstDir);
    }

    private void moveDirectory(File sourceDir, File targetDir) throws IOException {
        this.getLog().debug((CharSequence)("Moving JTB output files: " + sourceDir + " -> " + targetDir));
        File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles == null) {
            return;
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            File sourceFile = sourceFiles[i];
            if (!sourceFile.isFile() || !sourceFile.getName().endsWith(".java")) continue;
            try {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDir);
                if (sourceFile.delete()) continue;
                this.getLog().error((CharSequence)("Failed to delete original JTB output file: " + sourceFile));
                continue;
            }
            catch (Exception e) {
                throw new IOException("Failed to move JTB output file: " + sourceFile + " -> " + targetDir);
            }
        }
        if (sourceDir.list().length <= 0) {
            if (!sourceDir.delete()) {
                this.getLog().error((CharSequence)("Failed to delete original JTB output directory: " + sourceDir));
            }
        } else {
            this.getLog().debug((CharSequence)("Keeping non empty JTB output directory: " + sourceDir));
        }
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }

    class MojoLogStreamConsumer
    implements StreamConsumer {
        private static final String INFO_PREFIX = "JTB: ";
        private boolean err;

        public MojoLogStreamConsumer(boolean error) {
            this.err = error;
        }

        public void consumeLine(String line) {
            if (line.startsWith("JTB version")) {
                JTB.this.getLog().debug((CharSequence)line);
            } else if (line.startsWith(INFO_PREFIX)) {
                JTB.this.getLog().debug((CharSequence)line.substring(INFO_PREFIX.length()));
            } else if (this.err && line.length() > 0) {
                JTB.this.getLog().error((CharSequence)line);
            } else {
                JTB.this.getLog().debug((CharSequence)line);
            }
        }
    }
}

