/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo.validator;

import org.bytesoft.bytejta.supports.dubbo.DubboConfigValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;

public class ServiceConfigValidator
implements DubboConfigValidator {
    static final Logger logger = LoggerFactory.getLogger(ServiceConfigValidator.class);
    private String beanName;
    private BeanDefinition beanDefinition;

    public void validate() throws BeansException {
        MutablePropertyValues mpv = this.beanDefinition.getPropertyValues();
        PropertyValue retries = mpv.getPropertyValue("retries");
        PropertyValue loadbalance = mpv.getPropertyValue("loadbalance");
        PropertyValue cluster = mpv.getPropertyValue("cluster");
        PropertyValue filter = mpv.getPropertyValue("filter");
        PropertyValue group = mpv.getPropertyValue("group");
        if (retries == null || retries.getValue() == null || !"0".equals(retries.getValue())) {
            throw new FatalBeanException(String.format("The value of attr 'retries'(beanId= %s) should be '0'.", this.beanName));
        }
        if (loadbalance == null || loadbalance.getValue() == null || !"transaction".equals(loadbalance.getValue())) {
            throw new FatalBeanException(String.format("The value of attr 'loadbalance'(beanId= %s) should be 'transaction'.", this.beanName));
        }
        if (cluster == null || cluster.getValue() == null || !"failfast".equals(cluster.getValue())) {
            throw new FatalBeanException(String.format("The value of attribute 'cluster' (beanId= %s) must be 'failfast'.", this.beanName));
        }
        if (filter == null || filter.getValue() == null || !"transaction".equals(filter.getValue())) {
            throw new FatalBeanException(String.format("The value of attr 'filter'(beanId= %s) should be 'transaction'.", this.beanName));
        }
        if (group == null || group.getValue() == null || !("org.bytesoft.bytejta".equals(group.getValue()) || String.valueOf(group.getValue()).startsWith("org.bytesoft.bytejta-"))) {
            throw new FatalBeanException(String.format("The value of attr 'group'(beanId= %s) should be 'org.bytesoft.bytejta' or starts with 'org.bytesoft.bytejta-'.", this.beanName));
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public void setBeanDefinition(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
    }
}

