/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo.spi;

import com.alibaba.com.caucho.hessian.io.HessianHandle;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.dubbo.DubboRemoteCoordinator;
import org.bytesoft.bytejta.supports.dubbo.InvocationContext;
import org.bytesoft.bytejta.supports.dubbo.TransactionBeanRegistry;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinatorRegistry;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionManager;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionServiceFilter
implements Filter {
    static final String KEY_XA_RESOURCE_START = "start";
    static final Logger logger = LoggerFactory.getLogger(TransactionServiceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (RpcContext.getContext().isProviderSide()) {
            return this.providerInvoke(invoker, invocation);
        }
        return this.consumerInvoke(invoker, invocation);
    }

    public Result providerInvoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = RpcContext.getContext().getUrl();
        String interfaceClazz = url.getServiceInterface();
        if (StringUtils.equals((CharSequence)invocation.getMethodName(), (CharSequence)KEY_XA_RESOURCE_START) && Arrays.equals(invocation.getParameterTypes(), new Class[]{Xid.class, Integer.TYPE})) {
            return this.providerInvokeForKey(invoker, invocation);
        }
        if (XAResource.class.getName().equals(interfaceClazz)) {
            return this.providerInvokeForJTA(invoker, invocation);
        }
        if (RemoteCoordinator.class.getName().equals(interfaceClazz)) {
            return this.providerInvokeForJTA(invoker, invocation);
        }
        return this.providerInvokeForSVC(invoker, invocation);
    }

    public Result providerInvokeForKey(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RemoteCoordinatorRegistry coordinatorRegistry = RemoteCoordinatorRegistry.getInstance();
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator consumeCoordinator = beanRegistry.getConsumeCoordinator();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        String instanceId = StringUtils.trimToEmpty((String)invocation.getAttachment(RemoteCoordinator.class.getName()));
        RemoteCoordinator remoteCoordinator = coordinatorRegistry.getRemoteCoordinator(instanceId);
        if (StringUtils.isNotBlank((CharSequence)instanceId) && remoteCoordinator == null) {
            String[] values = instanceId == null ? new String[]{} : instanceId.split("\\s*:\\s*");
            String targetAddr = values.length == 3 ? values[0] : "";
            String targetName = values.length == 3 ? values[1] : "";
            String targetPort = values.length == 3 ? values[2] : String.valueOf(0);
            String remoteAddr = StringUtils.isBlank((CharSequence)targetAddr) && StringUtils.isBlank((CharSequence)targetPort) ? "" : String.format("%s:%s", targetAddr, targetPort);
            InvocationContext invocationContext = new InvocationContext();
            invocationContext.setServerHost(targetAddr);
            invocationContext.setServiceKey(targetName);
            invocationContext.setServerPort(Integer.valueOf(targetPort));
            DubboRemoteCoordinator dubboCoordinator = new DubboRemoteCoordinator();
            dubboCoordinator.setInvocationContext(invocationContext);
            dubboCoordinator.setRemoteCoordinator(consumeCoordinator);
            remoteCoordinator = (RemoteCoordinator)Proxy.newProxyInstance(DubboRemoteCoordinator.class.getClassLoader(), new Class[]{RemoteCoordinator.class}, (InvocationHandler)dubboCoordinator);
            coordinatorRegistry.putApplication(remoteAddr, targetName);
            coordinatorRegistry.putRemoteAddr(instanceId, remoteAddr);
            coordinatorRegistry.putRemoteCoordinator(instanceId, remoteCoordinator);
            coordinatorRegistry.putRemoteCoordinatorByAddr(remoteAddr, remoteCoordinator);
        }
        RpcResult result = new RpcResult();
        InvocationResult wrapped = new InvocationResult();
        wrapped.setVariable(RemoteCoordinator.class.getName(), (Serializable)((Object)transactionCoordinator.getIdentifier()));
        result.setException(null);
        result.setValue((Object)wrapped);
        return result;
    }

    public Result providerInvokeForJTA(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Class parameterType;
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        XidFactory xidFactory = beanFactory.getXidFactory();
        TransactionRepository transactionRepository = beanFactory.getTransactionRepository();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        Class[] parameterTypeArray = invocation.getParameterTypes();
        Class clazz = parameterType = parameterTypeArray == null || parameterTypeArray.length == 0 ? null : parameterTypeArray[0];
        if (parameterTypeArray == null || parameterTypeArray.length == 0) {
            return this.wrapResultForProvider(invoker, invocation, null, false);
        }
        if (!Xid.class.equals((Object)parameterType)) {
            return this.wrapResultForProvider(invoker, invocation, null, false);
        }
        RpcResult result = new RpcResult();
        Object[] arguments = invocation.getArguments();
        Xid xid = (Xid)arguments[0];
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        Transaction transaction = transactionRepository.getTransaction(globalXid);
        if (transaction == null) {
            InvocationResult wrapped = new InvocationResult();
            wrapped.setError(new XAException(-4));
            wrapped.setVariable(RemoteCoordinator.class.getName(), (Serializable)((Object)transactionCoordinator.getIdentifier()));
            result.setException(null);
            result.setValue((Object)wrapped);
        } else {
            String remoteAddr;
            TransactionContext transactionContext = transaction.getTransactionContext();
            String propagatedBy = String.valueOf(transactionContext.getPropagatedBy());
            if (StringUtils.equals((CharSequence)propagatedBy, (CharSequence)(remoteAddr = invocation.getAttachment(RemoteCoordinator.class.getName())))) {
                return this.wrapResultForProvider(invoker, invocation, propagatedBy, false);
            }
            InvocationResult wrapped = new InvocationResult();
            wrapped.setError(new XAException(-6));
            wrapped.setVariable(Propagation.class.getName(), (Serializable)((Object)String.valueOf(transactionContext.getPropagatedBy())));
            wrapped.setVariable(RemoteCoordinator.class.getName(), (Serializable)((Object)transactionCoordinator.getIdentifier()));
            result.setException(null);
            result.setValue((Object)wrapped);
            logger.warn("{}| branch should be invoked by its own coordinator(expect= {}, actual= {}).", new Object[]{globalXid, propagatedBy, remoteAddr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result providerInvokeForSVC(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        Object dubboCoordinator;
        RemoteCoordinatorRegistry coordinatorRegistry = RemoteCoordinatorRegistry.getInstance();
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionManager transactionManager = beanFactory.getTransactionManager();
        RemoteCoordinator consumeCoordinator = beanRegistry.getConsumeCoordinator();
        String instanceId = invocation.getAttachment(RemoteCoordinator.class.getName());
        RemoteCoordinator remoteCoordinator = coordinatorRegistry.getRemoteCoordinator(instanceId);
        if (StringUtils.isNotBlank((CharSequence)instanceId) && remoteCoordinator == null) {
            String[] values = instanceId == null ? new String[]{} : instanceId.split("\\s*:\\s*");
            String targetAddr = values.length == 3 ? values[0] : "";
            String targetName = values.length == 3 ? values[1] : "";
            String targetPort = values.length == 3 ? values[2] : String.valueOf(0);
            String remoteAddr = StringUtils.isBlank((CharSequence)targetAddr) && StringUtils.isBlank((CharSequence)targetPort) ? "" : String.format("%s:%s", targetAddr, targetPort);
            InvocationContext invocationContext = new InvocationContext();
            invocationContext.setServerHost(targetAddr);
            invocationContext.setServiceKey(targetName);
            invocationContext.setServerPort(Integer.valueOf(targetPort));
            dubboCoordinator = new DubboRemoteCoordinator();
            ((DubboRemoteCoordinator)dubboCoordinator).setInvocationContext(invocationContext);
            ((DubboRemoteCoordinator)dubboCoordinator).setRemoteCoordinator(consumeCoordinator);
            remoteCoordinator = (RemoteCoordinator)Proxy.newProxyInstance(DubboRemoteCoordinator.class.getClassLoader(), new Class[]{RemoteCoordinator.class}, (InvocationHandler)dubboCoordinator);
            coordinatorRegistry.putApplication(remoteAddr, targetName);
            coordinatorRegistry.putRemoteAddr(instanceId, remoteAddr);
            coordinatorRegistry.putRemoteCoordinator(instanceId, remoteCoordinator);
            coordinatorRegistry.putRemoteCoordinatorByAddr(remoteAddr, remoteCoordinator);
        }
        TransactionRequestImpl request = new TransactionRequestImpl();
        request.setTargetTransactionCoordinator(remoteCoordinator);
        TransactionResponseImpl response = new TransactionResponseImpl();
        response.setSourceTransactionCoordinator(remoteCoordinator);
        String propagatedBy = null;
        boolean failure = false;
        this.beforeProviderInvokeForSVC(invocation, request, response);
        Transaction transaction = transactionManager.getTransactionQuietly();
        TransactionContext transactionContext = transaction == null ? null : transaction.getTransactionContext();
        propagatedBy = transactionContext == null ? null : String.valueOf(transactionContext.getPropagatedBy());
        dubboCoordinator = this.wrapResultForProvider(invoker, invocation, propagatedBy, true);
        try {
            this.afterProviderInvokeForSVC(invocation, request, response);
        }
        catch (RpcException rex) {
            if (failure) {
                logger.error("Error occurred in remote call!", (Throwable)rex);
            }
            return this.createErrorResultForProvider(rex, propagatedBy, true);
        }
        catch (Throwable rex) {
            if (failure) {
                logger.error("Error occurred in remote call!", rex);
            }
            return this.createErrorResultForProvider(rex, propagatedBy, true);
        }
        return dubboCoordinator;
        catch (RpcException rex) {
            block27: {
                failure = true;
                result = this.createErrorResultForProvider(rex, propagatedBy, true);
                try {
                    this.afterProviderInvokeForSVC(invocation, request, response);
                }
                catch (RpcException rex2) {
                    if (failure) {
                        logger.error("Error occurred in remote call!", (Throwable)rex2);
                        break block27;
                    }
                    return this.createErrorResultForProvider(rex2, propagatedBy, true);
                }
                catch (Throwable rex3) {
                    if (failure) {
                        logger.error("Error occurred in remote call!", rex3);
                        break block27;
                    }
                    return this.createErrorResultForProvider(rex3, propagatedBy, true);
                }
            }
            return result;
        }
        catch (Throwable rex2) {
            block28: {
                failure = true;
                logger.error("Error occurred in remote call!", rex2);
                result = this.createErrorResultForProvider(rex2, propagatedBy, true);
                {
                    catch (Throwable throwable) {
                        block29: {
                            try {
                                this.afterProviderInvokeForSVC(invocation, request, response);
                            }
                            catch (RpcException rex4) {
                                if (failure) {
                                    logger.error("Error occurred in remote call!", (Throwable)rex4);
                                    break block29;
                                }
                                return this.createErrorResultForProvider(rex4, propagatedBy, true);
                            }
                            catch (Throwable rex5) {
                                if (failure) {
                                    logger.error("Error occurred in remote call!", rex5);
                                    break block29;
                                }
                                return this.createErrorResultForProvider(rex5, propagatedBy, true);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    this.afterProviderInvokeForSVC(invocation, request, response);
                }
                catch (RpcException rex6) {
                    if (failure) {
                        logger.error("Error occurred in remote call!", (Throwable)rex6);
                        break block28;
                    }
                    return this.createErrorResultForProvider(rex6, propagatedBy, true);
                }
                catch (Throwable rex7) {
                    if (failure) {
                        logger.error("Error occurred in remote call!", rex7);
                        break block28;
                    }
                    return this.createErrorResultForProvider(rex7, propagatedBy, true);
                }
            }
            return result;
        }
    }

    public Result wrapResultForProvider(Invoker<?> invoker, Invocation invocation, String propagatedBy, boolean attachRequired) {
        try {
            RpcResult result = (RpcResult)invoker.invoke(invocation);
            if (result.hasException()) {
                return this.createErrorResultForProvider(result.getException(), propagatedBy, attachRequired);
            }
            return this.convertResultForProvider(result, propagatedBy, attachRequired);
        }
        catch (Throwable rex) {
            return this.createErrorResultForProvider(rex, propagatedBy, attachRequired);
        }
    }

    private Result convertResultForProvider(RpcResult result, String propagatedBy, boolean attachRequired) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        Object value = result.getValue();
        InvocationResult wrapped = new InvocationResult();
        wrapped.setValue(value);
        if (attachRequired) {
            wrapped.setVariable(Propagation.class.getName(), (Serializable)((Object)propagatedBy));
            wrapped.setVariable(RemoteCoordinator.class.getName(), (Serializable)((Object)transactionCoordinator.getIdentifier()));
        }
        result.setException(null);
        result.setValue((Object)wrapped);
        return result;
    }

    private Result createErrorResultForProvider(Throwable throwable, String propagatedBy, boolean attachRequired) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        RpcResult result = new RpcResult();
        InvocationResult wrapped = new InvocationResult();
        wrapped.setError(throwable);
        if (attachRequired) {
            wrapped.setVariable(Propagation.class.getName(), (Serializable)((Object)propagatedBy));
            wrapped.setVariable(RemoteCoordinator.class.getName(), (Serializable)((Object)transactionCoordinator.getIdentifier()));
        }
        result.setException(null);
        result.setValue((Object)wrapped);
        return result;
    }

    private void beforeProviderInvokeForSVC(Invocation invocation, TransactionRequestImpl request, TransactionResponseImpl response) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        RpcException rpcError = null;
        String transactionContextContent = invocation.getAttachment(TransactionContext.class.getName());
        String propagatedBy = invocation.getAttachment(RemoteCoordinator.class.getName());
        if (StringUtils.isNotBlank((CharSequence)transactionContextContent)) {
            byte[] requestByteArray = ByteUtils.stringToByteArray((String)transactionContextContent);
            ByteArrayInputStream bais = new ByteArrayInputStream(requestByteArray);
            HessianInput input = new HessianInput((InputStream)bais);
            try {
                TransactionContext remoteTransactionContext = (TransactionContext)input.readObject();
                remoteTransactionContext.setPropagatedBy((Object)propagatedBy);
                request.setTransactionContext(remoteTransactionContext);
            }
            catch (IOException ex) {
                logger.error("Error occurred in remote call!", (Throwable)ex);
                rpcError = new RpcException("Error occurred in remote call!", (Throwable)ex);
            }
        }
        try {
            transactionInterceptor.afterReceiveRequest((TransactionRequest)request);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred in remote call!", (Throwable)rex);
            throw new RpcException("Error occurred in remote call!", (Throwable)rex);
        }
        if (rpcError != null) {
            throw rpcError;
        }
    }

    private void afterProviderInvokeForSVC(Invocation invocation, TransactionRequestImpl request, TransactionResponseImpl response) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        TransactionManager transactionManager = beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        TransactionContext nativeTransactionContext = transaction == null ? null : transaction.getTransactionContext();
        response.setTransactionContext(nativeTransactionContext);
        try {
            transactionInterceptor.beforeSendResponse((TransactionResponse)response);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred in remote call!", (Throwable)rex);
            throw new RpcException("Error occurred in remote call!", (Throwable)rex);
        }
    }

    public Result consumerInvoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = RpcContext.getContext().getUrl();
        String interfaceClazz = url.getServiceInterface();
        if (StringUtils.equals((CharSequence)invocation.getMethodName(), (CharSequence)KEY_XA_RESOURCE_START) && Arrays.equals(invocation.getParameterTypes(), new Class[]{Xid.class, Integer.TYPE})) {
            return this.consumerInvokeForKey(invoker, invocation);
        }
        if (XAResource.class.getName().equals(interfaceClazz)) {
            return this.consumerInvokeForJTA(invoker, invocation);
        }
        if (RemoteCoordinator.class.getName().equals(interfaceClazz)) {
            return this.consumerInvokeForJTA(invoker, invocation);
        }
        return this.consumerInvokeForSVC(invoker, invocation);
    }

    public Result consumerInvokeForKey(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RemoteCoordinatorRegistry coordinatorRegistry = RemoteCoordinatorRegistry.getInstance();
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        RemoteCoordinator consumeCoordinator = beanRegistry.getConsumeCoordinator();
        String instanceId = null;
        Map attachments = invocation.getAttachments();
        attachments.put(RemoteCoordinator.class.getName(), transactionCoordinator.getIdentifier());
        RpcResult result = (RpcResult)invoker.invoke(invocation);
        Object value = result.getValue();
        if (InvocationResult.class.isInstance(value)) {
            InvocationResult wrapped = (InvocationResult)value;
            result.setValue(null);
            result.setException(null);
            if (wrapped.isFailure()) {
                result.setException(wrapped.getError());
            } else {
                result.setValue(wrapped.getValue());
            }
            instanceId = StringUtils.trimToEmpty((String)String.valueOf(wrapped.getVariable(RemoteCoordinator.class.getName())));
        }
        if (StringUtils.isNotBlank(instanceId) && coordinatorRegistry.getRemoteCoordinator(instanceId) == null) {
            String[] values = instanceId == null ? new String[]{} : instanceId.split("\\s*:\\s*");
            String targetAddr = values.length == 3 ? values[0] : "";
            String targetName = values.length == 3 ? values[1] : "";
            String targetPort = values.length == 3 ? values[2] : String.valueOf(0);
            String remoteAddr = StringUtils.isBlank((CharSequence)targetAddr) && StringUtils.isBlank((CharSequence)targetPort) ? "" : String.format("%s:%s", targetAddr, targetPort);
            coordinatorRegistry.putApplication(remoteAddr, targetName);
            coordinatorRegistry.putRemoteAddr(instanceId, remoteAddr);
            RemoteCoordinator remoteCoordinator = coordinatorRegistry.getRemoteCoordinatorByAddr(remoteAddr);
            if (remoteCoordinator == null) {
                InvocationContext invocationContext = new InvocationContext();
                invocationContext.setServerHost(targetAddr);
                invocationContext.setServiceKey(targetName);
                invocationContext.setServerPort(Integer.valueOf(targetPort));
                DubboRemoteCoordinator dubboCoordinator = new DubboRemoteCoordinator();
                dubboCoordinator.setInvocationContext(invocationContext);
                dubboCoordinator.setRemoteCoordinator(consumeCoordinator);
                remoteCoordinator = (RemoteCoordinator)Proxy.newProxyInstance(DubboRemoteCoordinator.class.getClassLoader(), new Class[]{RemoteCoordinator.class}, (InvocationHandler)dubboCoordinator);
                coordinatorRegistry.putRemoteCoordinatorByAddr(remoteAddr, remoteCoordinator);
                coordinatorRegistry.putRemoteCoordinator(instanceId, remoteCoordinator);
            } else {
                DubboRemoteCoordinator dubboCoordinator = (DubboRemoteCoordinator)Proxy.getInvocationHandler(remoteCoordinator);
                dubboCoordinator.getInvocationContext().setServiceKey(targetName);
                coordinatorRegistry.putRemoteCoordinator(instanceId, remoteCoordinator);
            }
        }
        return result;
    }

    public Result consumerInvokeForJTA(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        Map attachments = invocation.getAttachments();
        attachments.put(RemoteCoordinator.class.getName(), transactionCoordinator.getIdentifier());
        RpcResult result = (RpcResult)invoker.invoke(invocation);
        Object value = result.getValue();
        if (InvocationResult.class.isInstance(value)) {
            InvocationResult wrapped = (InvocationResult)value;
            result.setValue(null);
            result.setException(null);
            if (wrapped.isFailure()) {
                result.setException(wrapped.getError());
            } else {
                result.setValue(wrapped.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result consumerInvokeForSVC(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RemoteCoordinator remoteCoordinator;
        RemoteCoordinatorRegistry coordinatorRegistry = RemoteCoordinatorRegistry.getInstance();
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        RemoteCoordinator consumeCoordinator = beanRegistry.getConsumeCoordinator();
        TransactionManager transactionManager = beanFactory.getTransactionManager();
        Transaction transaction = transactionManager.getTransactionQuietly();
        TransactionContext nativeTransactionContext = transaction == null ? null : transaction.getTransactionContext();
        URL targetUrl = invoker.getUrl();
        String targetAddr = targetUrl.getIp();
        int targetPort = targetUrl.getPort();
        String remoteAddr = String.format("%s:%s", targetAddr, targetPort);
        String targetName = coordinatorRegistry.getApplication(remoteAddr);
        String instanceId = String.format("%s:%s:%s", targetAddr, targetName, targetPort);
        InvocationContext invocationContext = new InvocationContext();
        invocationContext.setServerHost(targetAddr);
        invocationContext.setServiceKey(targetName);
        invocationContext.setServerPort(targetPort);
        RemoteCoordinator remoteCoordinator2 = remoteCoordinator = StringUtils.isNotBlank((CharSequence)targetName) ? coordinatorRegistry.getRemoteCoordinator(instanceId) : coordinatorRegistry.getRemoteCoordinatorByAddr(remoteAddr);
        if (remoteCoordinator == null) {
            DubboRemoteCoordinator dubboCoordinator = new DubboRemoteCoordinator();
            dubboCoordinator.setInvocationContext(invocationContext);
            dubboCoordinator.setRemoteCoordinator(consumeCoordinator);
            remoteCoordinator = (RemoteCoordinator)Proxy.newProxyInstance(DubboRemoteCoordinator.class.getClassLoader(), new Class[]{RemoteCoordinator.class}, (InvocationHandler)dubboCoordinator);
            coordinatorRegistry.putRemoteCoordinatorByAddr(remoteAddr, remoteCoordinator);
        }
        TransactionRequestImpl request = new TransactionRequestImpl();
        request.setTransactionContext(nativeTransactionContext);
        request.setTargetTransactionCoordinator(remoteCoordinator);
        TransactionResponseImpl response = new TransactionResponseImpl();
        response.setSourceTransactionCoordinator(remoteCoordinator);
        RpcResult result = null;
        RpcException invokeError = null;
        Throwable serverError = null;
        try {
            this.beforeConsumerInvokeForSVC(invocation, request, response);
            result = (RpcResult)invoker.invoke(invocation);
            Object value = result.getValue();
            if (InvocationResult.class.isInstance(value)) {
                InvocationResult wrapped = (InvocationResult)value;
                result.setValue(null);
                result.setException(null);
                if (wrapped.isFailure()) {
                    result.setException(wrapped.getError());
                    serverError = wrapped.getError();
                } else {
                    result.setValue(wrapped.getValue());
                }
                String propagatedBy = (String)((Object)wrapped.getVariable(Propagation.class.getName()));
                String identifier = transactionCoordinator.getIdentifier();
                boolean participantDelistRequired = !StringUtils.equals((CharSequence)propagatedBy, (CharSequence)identifier);
                response.setParticipantDelistFlag(participantDelistRequired);
                response.setParticipantEnlistFlag(request.isParticipantEnlistFlag());
            }
        }
        catch (RpcException rex) {
            invokeError = rex;
        }
        catch (Throwable rex) {
            logger.error("Error occurred in remote call!", rex);
            invokeError = new RpcException(rex.getMessage());
        }
        finally {
            try {
                this.afterConsumerInvokeForSVC(invocation, request, response);
            }
            catch (RpcException rex) {
                if (invokeError == null) {
                    throw rex;
                }
                logger.error("Error occurred in remote call!", (Throwable)rex);
                throw invokeError;
            }
            catch (RuntimeException rex) {
                if (invokeError == null) {
                    throw new RpcException(rex.getMessage());
                }
                logger.error("Error occurred in remote call!", (Throwable)rex);
                throw invokeError;
            }
        }
        if (serverError == null && invokeError == null) {
            return result;
        }
        if (serverError == null && invokeError != null) {
            throw invokeError;
        }
        if (RpcException.class.isInstance(serverError)) {
            throw (RpcException)serverError;
        }
        return result;
    }

    private void beforeConsumerInvokeForSVC(Invocation invocation, TransactionRequestImpl request, TransactionResponseImpl response) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        RemoteCoordinator transactionCoordinator = beanFactory.getTransactionCoordinator();
        Map attachments = invocation.getAttachments();
        attachments.put(RemoteCoordinator.class.getName(), transactionCoordinator.getIdentifier());
        transactionInterceptor.beforeSendRequest((TransactionRequest)request);
        if (request.getTransactionContext() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HessianOutput output = new HessianOutput((OutputStream)baos);
            try {
                output.writeObject((Object)request.getTransactionContext());
            }
            catch (IOException ex) {
                logger.error("Error occurred in remote call!", (Throwable)ex);
                throw new RpcException("Error occurred in remote call!", (Throwable)ex);
            }
            String transactionContextContent = ByteUtils.byteArrayToString((byte[])baos.toByteArray());
            attachments.put(TransactionContext.class.getName(), transactionContextContent);
        }
    }

    private void afterConsumerInvokeForSVC(Invocation invocation, TransactionRequestImpl request, TransactionResponseImpl response) {
        TransactionBeanRegistry beanRegistry = TransactionBeanRegistry.getInstance();
        TransactionBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        RpcException rpcError = null;
        try {
            if (request.getTransactionContext() != null) {
                String transactionContextContent = invocation.getAttachment(TransactionContext.class.getName());
                byte[] byteArray = ByteUtils.stringToByteArray((String)transactionContextContent);
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
                HessianInput input = new HessianInput((InputStream)bais);
                TransactionContext remoteTransactionContext = (TransactionContext)input.readObject();
                response.setTransactionContext(remoteTransactionContext);
            }
        }
        catch (IOException ex) {
            logger.error("Error occurred in remote call!", (Throwable)ex);
            rpcError = new RpcException("Error occurred in remote call!", (Throwable)ex);
        }
        try {
            transactionInterceptor.afterReceiveResponse((TransactionResponse)response);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred in remote call!", (Throwable)rex);
            throw new RpcException("Error occurred in remote call!", (Throwable)rex);
        }
        if (rpcError != null) {
            throw rpcError;
        }
    }

    static class InvocationResult
    implements HessianHandle,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Throwable error;
        private Object value;
        private final Map<String, Serializable> variables = new HashMap<String, Serializable>();

        InvocationResult() {
        }

        public boolean isFailure() {
            return this.error != null;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setVariable(String key, Serializable value) {
            this.variables.put(key, value);
        }

        public Serializable getVariable(String key) {
            return this.variables.get(key);
        }

        public Throwable getError() {
            return this.error;
        }

        public void setError(Throwable error) {
            this.error = error;
        }
    }
}

