/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import java.util.ArrayList;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class TransactionEndpointPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        BeanDefinition applicationDef = null;
        BeanDefinition protocolDef = null;
        ArrayList<BeanDefinition> beanDefList = new ArrayList<BeanDefinition>();
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            String beanClassName = beanDef.getBeanClassName();
            Class<?> beanClass = null;
            try {
                beanClass = cl.loadClass(beanClassName);
            }
            catch (Exception ex) {
                continue;
            }
            if (TransactionEndpointAware.class.isAssignableFrom(beanClass)) {
                beanDefList.add(beanDef);
                continue;
            }
            if (ProtocolConfig.class.isAssignableFrom(beanClass)) {
                if (protocolDef == null) {
                    protocolDef = beanDef;
                    continue;
                }
                throw new FatalBeanException("There are more than one com.alibaba.dubbo.config.ProtocolConfig was found!");
            }
            if (!ApplicationConfig.class.isAssignableFrom(beanClass)) continue;
            if (applicationDef == null) {
                applicationDef = beanDef;
                continue;
            }
            throw new FatalBeanException("There are more than one com.alibaba.dubbo.config.ApplicationConfig was found!");
        }
        if (applicationDef == null) {
            throw new FatalBeanException("No configuration of class com.alibaba.dubbo.config.ApplicationConfig was found.");
        }
        if (protocolDef == null) {
            throw new FatalBeanException("No configuration of class com.alibaba.dubbo.config.ProtocolConfig was found.");
        }
        MutablePropertyValues applicationValues = applicationDef.getPropertyValues();
        PropertyValue applicationValue = applicationValues.getPropertyValue("name");
        if (applicationValue == null || applicationValue.getValue() == null) {
            throw new FatalBeanException("Attribute 'name' of <dubbo:application ... /> is null.");
        }
        MutablePropertyValues protocolValues = protocolDef.getPropertyValues();
        PropertyValue protocolValue = protocolValues.getPropertyValue("port");
        if (protocolValue == null || protocolValue.getValue() == null) {
            throw new FatalBeanException("Attribute 'port' of <dubbo:protocol ... /> is null.");
        }
        String host = CommonUtils.getInetAddress();
        String name = String.valueOf(applicationValue.getValue());
        String port = String.valueOf(protocolValue.getValue());
        String identifier = String.format("%s:%s:%s", host, name, port);
        for (int i = 0; i < beanDefList.size(); ++i) {
            BeanDefinition beanDef = (BeanDefinition)beanDefList.get(i);
            MutablePropertyValues mpv = beanDef.getPropertyValues();
            mpv.addPropertyValue("endpoint", (Object)identifier);
        }
    }
}

