/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.TransactionCoordinator;
import org.bytesoft.bytejta.supports.dubbo.TransactionBeanRegistry;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class TransactionConfigPostProcessor
implements BeanFactoryPostProcessor {
    static final Logger logger = LoggerFactory.getLogger(TransactionConfigPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        String applicationBeanId = null;
        String registryBeanId = null;
        String transactionBeanId = null;
        for (int i = 0; i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            String beanClassName = beanDef.getBeanClassName();
            if (ApplicationConfig.class.getName().equals(beanClassName)) {
                if (StringUtils.isBlank(applicationBeanId)) {
                    applicationBeanId = beanName;
                    continue;
                }
                throw new FatalBeanException("There are more than one application name was found!");
            }
            if (TransactionCoordinator.class.getName().equals(beanClassName)) {
                if (StringUtils.isBlank(transactionBeanId)) {
                    transactionBeanId = beanName;
                    continue;
                }
                throw new FatalBeanException("There are more than one org.bytesoft.bytejta.TransactionCoordinator was found!");
            }
            if (!TransactionBeanRegistry.class.getName().equals(beanClassName)) continue;
            if (StringUtils.isBlank(registryBeanId)) {
                registryBeanId = beanName;
                continue;
            }
            throw new FatalBeanException("There are more than one org.bytesoft.bytejta.supports.dubbo.TransactionBeanRegistry was found!");
        }
        if (StringUtils.isBlank(applicationBeanId)) {
            throw new FatalBeanException("No application name was found!");
        }
        BeanDefinition beanDef = beanFactory.getBeanDefinition(applicationBeanId);
        MutablePropertyValues mpv = beanDef.getPropertyValues();
        PropertyValue pv = mpv.getPropertyValue("name");
        if (pv == null || pv.getValue() == null || StringUtils.isBlank((CharSequence)String.valueOf(pv.getValue()))) {
            throw new FatalBeanException("No application name was found!");
        }
        if (StringUtils.isBlank((CharSequence)transactionBeanId)) {
            throw new FatalBeanException("No configuration of class org.bytesoft.bytejta.TransactionCoordinator was found.");
        }
        if (registryBeanId == null) {
            throw new FatalBeanException("No configuration of class org.bytesoft.bytejta.supports.dubbo.TransactionBeanRegistry was found.");
        }
        String application = String.valueOf(pv.getValue());
        this.initializeForProvider(beanFactory, application, transactionBeanId);
        this.initializeForConsumer(beanFactory, application, registryBeanId);
    }

    public void initializeForProvider(ConfigurableListableBeanFactory beanFactory, String application, String refBeanName) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(ServiceBean.class);
        MutablePropertyValues mpv = beanDef.getPropertyValues();
        mpv.addPropertyValue("interface", (Object)RemoteCoordinator.class.getName());
        mpv.addPropertyValue("ref", (Object)new RuntimeBeanReference(refBeanName));
        mpv.addPropertyValue("cluster", (Object)"failfast");
        mpv.addPropertyValue("loadbalance", (Object)"transaction");
        mpv.addPropertyValue("filter", (Object)"transaction");
        mpv.addPropertyValue("group", (Object)"org.bytesoft.bytejta");
        mpv.addPropertyValue("retries", (Object)"0");
        mpv.addPropertyValue("timeout", (Object)"6000");
        String skeletonBeanId = String.format("skeleton@%s", RemoteCoordinator.class.getName());
        registry.registerBeanDefinition(skeletonBeanId, (BeanDefinition)beanDef);
    }

    public void initializeForConsumer(ConfigurableListableBeanFactory beanFactory, String application, String targetBeanName) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setBeanClass(ReferenceBean.class);
        MutablePropertyValues mpv = beanDef.getPropertyValues();
        mpv.addPropertyValue("interface", (Object)RemoteCoordinator.class.getName());
        mpv.addPropertyValue("timeout", (Object)"6000");
        mpv.addPropertyValue("cluster", (Object)"failfast");
        mpv.addPropertyValue("loadbalance", (Object)"transaction");
        mpv.addPropertyValue("filter", (Object)"transaction");
        mpv.addPropertyValue("group", (Object)"org.bytesoft.bytejta");
        mpv.addPropertyValue("check", (Object)"false");
        String stubBeanId = String.format("stub@%s", RemoteCoordinator.class.getName());
        registry.registerBeanDefinition(stubBeanId, (BeanDefinition)beanDef);
        BeanDefinition targetBeanDef = beanFactory.getBeanDefinition(targetBeanName);
        MutablePropertyValues targetMpv = targetBeanDef.getPropertyValues();
        targetMpv.addPropertyValue("consumeCoordinator", (Object)new RuntimeBeanReference(stubBeanId));
    }
}

