/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class TransactionBeanRegistry
implements TransactionBeanFactoryAware,
EnvironmentAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionBeanRegistry.class);
    private static final TransactionBeanRegistry instance = new TransactionBeanRegistry();
    private RemoteCoordinator consumeCoordinator;
    private Environment environment;
    @Inject
    private TransactionBeanFactory beanFactory;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    private TransactionBeanRegistry() {
        if (instance != null) {
            throw new IllegalStateException();
        }
    }

    public static TransactionBeanRegistry getInstance() {
        return instance;
    }

    public RemoteCoordinator getConsumeCoordinator() {
        if (this.consumeCoordinator != null) {
            return this.consumeCoordinator;
        }
        return this.doGetConsumeCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteCoordinator doGetConsumeCoordinator() {
        try {
            this.lock.lock();
            while (this.consumeCoordinator == null) {
                try {
                    this.condition.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    logger.debug(ex.getMessage());
                }
            }
            RemoteCoordinator remoteCoordinator = this.consumeCoordinator;
            return remoteCoordinator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumeCoordinator(RemoteCoordinator consumeCoordinator) {
        block4: {
            try {
                this.lock.lock();
                if (this.consumeCoordinator == null) {
                    this.consumeCoordinator = consumeCoordinator;
                    this.condition.signalAll();
                    break block4;
                }
                throw new IllegalStateException("Field 'consumeCoordinator' has already been set, please check your app whether it imports ByteJTA repeatedly!");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

