/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.dubbo.InvocationContext;
import org.bytesoft.bytejta.supports.dubbo.InvocationContextRegistry;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinatorRegistry;

public class DubboRemoteCoordinator
implements InvocationHandler {
    private InvocationContext invocationContext;
    private RemoteCoordinator remoteCoordinator;

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationContextRegistry registry = InvocationContextRegistry.getInstance();
        try {
            registry.associateInvocationContext(this.invocationContext);
            Class<?> clazz = method.getDeclaringClass();
            String methodName = method.getName();
            if (Object.class.equals(clazz)) {
                Object object = method.invoke((Object)this, args);
                return object;
            }
            if (RemoteCoordinator.class.equals(clazz)) {
                if ("getIdentifier".equals(methodName)) {
                    String serverHost = this.invocationContext == null ? null : this.invocationContext.getServerHost();
                    String serviceKey = this.invocationContext == null ? null : this.invocationContext.getServiceKey();
                    int serverPort = this.invocationContext == null ? 0 : this.invocationContext.getServerPort();
                    String string = this.invocationContext == null ? null : String.format("%s:%s:%s", serverHost, serviceKey, serverPort);
                    return string;
                }
                if ("getApplication".equals(methodName)) {
                    if (this.invocationContext == null) {
                        Object serverHost = null;
                        return serverHost;
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.invocationContext.getServiceKey())) {
                        String serverHost = this.invocationContext.getServiceKey();
                        return serverHost;
                    }
                    Object serverHost = this.invokeCoordinator(proxy, method, args);
                    return serverHost;
                }
                throw new XAException(-7);
            }
            if (XAResource.class.equals(clazz)) {
                String serverHost = this.invocationContext == null ? null : this.invocationContext.getServerHost();
                int serverPort = this.invocationContext == null ? 0 : this.invocationContext.getServerPort();
                String remoteAddr = String.format("%s:%s", serverHost, serverPort);
                if ("start".equals(methodName)) {
                    RemoteCoordinatorRegistry coordinatorRegistry = RemoteCoordinatorRegistry.getInstance();
                    if (this.invocationContext == null) {
                        throw new IllegalAccessException();
                    }
                    if (coordinatorRegistry.containsApplication(remoteAddr)) {
                        Object var11_24 = null;
                        return var11_24;
                    }
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                if ("prepare".equals(methodName)) {
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                if ("commit".equals(methodName)) {
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                if ("rollback".equals(methodName)) {
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                if ("recover".equals(methodName)) {
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                if ("forget".equals(methodName)) {
                    Object object = this.invokeCoordinator(proxy, method, args);
                    return object;
                }
                throw new XAException(-7);
            }
            throw new IllegalAccessException();
        }
        finally {
            registry.desociateInvocationContext();
        }
    }

    public Object invokeCoordinator(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.remoteCoordinator, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public void setInvocationContext(InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    public RemoteCoordinator getRemoteCoordinator() {
        return this.remoteCoordinator;
    }

    public void setRemoteCoordinator(RemoteCoordinator remoteCoordinator) {
        this.remoteCoordinator = remoteCoordinator;
    }
}

