/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bytesoft.bytejta.supports.dubbo.DubboConfigValidator;
import org.bytesoft.bytejta.supports.dubbo.validator.ApplicationConfigValidator;
import org.bytesoft.bytejta.supports.dubbo.validator.ProtocolConfigValidator;
import org.bytesoft.bytejta.supports.dubbo.validator.ProviderConfigValidator;
import org.bytesoft.bytejta.supports.dubbo.validator.ReferenceConfigValidator;
import org.bytesoft.bytejta.supports.dubbo.validator.ServiceConfigValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DubboConfigPostProcessor
implements BeanFactoryPostProcessor {
    static final Logger logger = LoggerFactory.getLogger(DubboConfigPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DubboConfigValidator validator;
        MutablePropertyValues mpv;
        String beanClassName;
        BeanDefinition beanDef;
        String beanName;
        int i;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<BeanDefinition> appNameList = new ArrayList<BeanDefinition>();
        ArrayList<BeanDefinition> providerList = new ArrayList<BeanDefinition>();
        ArrayList<BeanDefinition> consumerList = new ArrayList<BeanDefinition>();
        ArrayList<BeanDefinition> protocolList = new ArrayList<BeanDefinition>();
        ArrayList<BeanDefinition> registryList = new ArrayList<BeanDefinition>();
        HashMap<String, BeanDefinition> serviceMap = new HashMap<String, BeanDefinition>();
        HashMap<String, BeanDefinition> referenceMap = new HashMap<String, BeanDefinition>();
        HashMap clazzMap = new HashMap();
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        for (i = 0; i < beanNameArray.length; ++i) {
            Class<?> clazz;
            beanName = beanNameArray[i];
            beanDef = beanFactory.getBeanDefinition(beanName);
            beanClassName = beanDef.getBeanClassName();
            Object var16_18 = null;
            try {
                clazz = cl.loadClass(beanClassName);
            }
            catch (Exception ex) {
                logger.debug("Cannot load class {}, beanId= {}!", new Object[]{beanClassName, beanName, ex});
                continue;
            }
            clazzMap.put(beanClassName, clazz);
        }
        for (i = 0; i < beanNameArray.length; ++i) {
            PropertyValue group;
            beanName = beanNameArray[i];
            beanDef = beanFactory.getBeanDefinition(beanName);
            beanClassName = beanDef.getBeanClassName();
            Class clazz = (Class)clazzMap.get(beanClassName);
            if (ApplicationConfig.class.equals((Object)clazz)) {
                appNameList.add(beanDef);
                continue;
            }
            if (ProtocolConfig.class.equals((Object)clazz)) {
                protocolList.add(beanDef);
                continue;
            }
            if (RegistryConfig.class.equals((Object)clazz)) {
                registryList.add(beanDef);
                continue;
            }
            if (ProviderConfig.class.equals((Object)clazz)) {
                providerList.add(beanDef);
                continue;
            }
            if (ConsumerConfig.class.equals((Object)clazz)) {
                consumerList.add(beanDef);
                continue;
            }
            if (ServiceBean.class.equals((Object)clazz)) {
                mpv = beanDef.getPropertyValues();
                group = mpv.getPropertyValue("group");
                if (group == null || group.getValue() == null || !("org.bytesoft.bytejta".equals(group.getValue()) || String.valueOf(group.getValue()).startsWith("org.bytesoft.bytejta-"))) continue;
                serviceMap.put(beanName, beanDef);
                continue;
            }
            if (!ReferenceBean.class.equals((Object)clazz) || (group = (mpv = beanDef.getPropertyValues()).getPropertyValue("group")) == null || group.getValue() == null || !("org.bytesoft.bytejta".equals(group.getValue()) || String.valueOf(group.getValue()).startsWith("org.bytesoft.bytejta-"))) continue;
            referenceMap.put(beanName, beanDef);
        }
        HashSet providerSet = new HashSet();
        HashSet protocolSet = new HashSet();
        for (Map.Entry entry : serviceMap.entrySet()) {
            String protocolValue;
            String providerValue;
            BeanDefinition beanDefinition = (BeanDefinition)entry.getValue();
            mpv = beanDefinition.getPropertyValues();
            PropertyValue provider = mpv.getPropertyValue("provider");
            PropertyValue protocol = mpv.getPropertyValue("protocol");
            String string = providerValue = provider == null ? null : String.valueOf(provider.getValue());
            if (providerValue == null) {
                if (providerList.size() > 0) {
                    providerSet.add(providerList.get(0));
                }
            } else if (!"N/A".equals(providerValue)) {
                String[] keyArray = providerValue.split("\\s*,\\s*");
                for (int j = 0; j < keyArray.length; ++j) {
                    String key = keyArray[j];
                    BeanDefinition def = beanFactory.getBeanDefinition(key);
                    providerSet.add(def);
                }
            }
            String string2 = protocolValue = protocol == null ? null : String.valueOf(protocol.getValue());
            if (protocolValue == null) {
                if (protocolList.size() <= 0) continue;
                protocolSet.add(protocolList.get(0));
                continue;
            }
            if ("N/A".equals(protocolValue)) continue;
            String[] keyArray = protocolValue.split("\\s*,\\s*");
            for (int i2 = 0; i2 < keyArray.length; ++i2) {
                String key = keyArray[i2];
                BeanDefinition def = beanFactory.getBeanDefinition(key);
                protocolSet.add(def);
            }
        }
        ApplicationConfigValidator appConfigValidator = new ApplicationConfigValidator();
        appConfigValidator.setDefinitionList(appNameList);
        appConfigValidator.validate();
        if (protocolList.size() == 0) {
            throw new FatalBeanException("There is no protocol config specified!");
        }
        for (BeanDefinition beanDefinition : protocolSet) {
            validator = new ProtocolConfigValidator();
            ((ProtocolConfigValidator)validator).setBeanDefinition(beanDefinition);
            ((ProtocolConfigValidator)validator).validate();
        }
        for (BeanDefinition beanDefinition : providerSet) {
            validator = new ProviderConfigValidator();
            ((ProviderConfigValidator)validator).setBeanDefinition(beanDefinition);
            ((ProviderConfigValidator)validator).validate();
        }
        for (Map.Entry entry : serviceMap.entrySet()) {
            validator = new ServiceConfigValidator();
            ((ServiceConfigValidator)validator).setBeanName((String)entry.getKey());
            ((ServiceConfigValidator)validator).setBeanDefinition((BeanDefinition)entry.getValue());
            ((ServiceConfigValidator)validator).validate();
        }
        for (Map.Entry entry : referenceMap.entrySet()) {
            validator = new ReferenceConfigValidator();
            ((ReferenceConfigValidator)validator).setBeanName((String)entry.getKey());
            ((ReferenceConfigValidator)validator).setBeanDefinition((BeanDefinition)entry.getValue());
            ((ReferenceConfigValidator)validator).validate();
        }
    }
}

