/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveDirCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class HiveAnalysis$
extends Rule<LogicalPlan> {
    public static final HiveAnalysis$ MODULE$;

    static {
        new HiveAnalysis$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transformUp((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                void var13_18;
                boolean bl = false;
                CreateTable createTable2 = null;
                A1 A1 = x3;
                if (A1 instanceof InsertIntoTable) {
                    HiveTableRelation hiveTableRelation;
                    InsertIntoTable insertIntoTable = (InsertIntoTable)A1;
                    LogicalPlan r = insertIntoTable.table();
                    Map partSpec = insertIntoTable.partition();
                    LogicalPlan query = insertIntoTable.query();
                    boolean overwrite = insertIntoTable.overwrite();
                    boolean ifPartitionNotExists = insertIntoTable.ifPartitionNotExists();
                    if (r instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                        InsertIntoHiveTable insertIntoHiveTable = new InsertIntoHiveTable(hiveTableRelation.tableMeta(), (Map<String, Option<String>>)partSpec, query, overwrite, ifPartitionNotExists, (Seq<Attribute>)query.output());
                        return var13_18;
                    }
                }
                if (A1 instanceof CreateTable) {
                    bl = true;
                    createTable2 = (CreateTable)A1;
                    CatalogTable tableDesc = createTable2.tableDesc();
                    SaveMode mode = createTable2.mode();
                    Option option = createTable2.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        DDLUtils$.MODULE$.checkDataColNames(tableDesc);
                        SaveMode saveMode = mode;
                        SaveMode saveMode2 = SaveMode.Ignore;
                        CreateTableCommand createTableCommand = new CreateTableCommand(tableDesc, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
                        return var13_18;
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable2.tableDesc();
                    SaveMode mode = createTable2.mode();
                    Option option = createTable2.query();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LogicalPlan query = (LogicalPlan)some.x();
                        if (DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                            DDLUtils$.MODULE$.checkDataColNames(tableDesc);
                            CreateHiveTableAsSelectCommand createHiveTableAsSelectCommand = new CreateHiveTableAsSelectCommand(tableDesc, query, (Seq<Attribute>)query.output(), mode);
                            return var13_18;
                        }
                    }
                }
                if (A1 instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)A1;
                    boolean isLocal = insertIntoDir.isLocal();
                    CatalogStorageFormat storage = insertIntoDir.storage();
                    Option provider = insertIntoDir.provider();
                    LogicalPlan child = insertIntoDir.child();
                    boolean overwrite = insertIntoDir.overwrite();
                    if (DDLUtils$.MODULE$.isHiveTable(provider)) {
                        Path outputPath = new Path((URI)storage.locationUri().get());
                        if (overwrite) {
                            DDLUtils$.MODULE$.verifyNotReadPath(child, outputPath);
                        }
                        InsertIntoHiveDirCommand insertIntoHiveDirCommand = new InsertIntoHiveDirCommand(isLocal, storage, child, overwrite, (Seq<Attribute>)child.output());
                        return var13_18;
                    }
                }
                Object object = function1.apply(x3);
                return var13_18;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x3) {
                HiveTableRelation hiveTableRelation;
                InsertIntoTable insertIntoTable;
                LogicalPlan r;
                boolean bl = false;
                CreateTable createTable2 = null;
                LogicalPlan logicalPlan = x3;
                if (logicalPlan instanceof InsertIntoTable && (r = (insertIntoTable = (InsertIntoTable)logicalPlan).table()) instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                    return true;
                }
                if (logicalPlan instanceof CreateTable) {
                    bl = true;
                    createTable2 = (CreateTable)logicalPlan;
                    CatalogTable tableDesc = createTable2.tableDesc();
                    Option option = createTable2.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        return true;
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable2.tableDesc();
                    Option option = createTable2.query();
                    if (option instanceof Some && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        return true;
                    }
                }
                if (!(logicalPlan instanceof InsertIntoDir)) return false;
                InsertIntoDir insertIntoDir = (InsertIntoDir)logicalPlan;
                Option provider = insertIntoDir.provider();
                if (!DDLUtils$.MODULE$.isHiveTable(provider)) return false;
                return true;
            }
        });
    }

    private HiveAnalysis$() {
        MODULE$ = this;
    }
}

