/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.checker;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.TableRuleSegment;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class ShardingTableRuleStatementChecker {
    private static final String DELIMITER = ".";

    public static void checkCreation(ShardingSphereMetaData shardingSphereMetaData, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShardingTableRuleStatementChecker.check(shardingSphereMetaData, rules, currentRuleConfig, true);
    }

    public static void checkAlteration(ShardingSphereMetaData shardingSphereMetaData, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShardingTableRuleStatementChecker.check(shardingSphereMetaData, rules, currentRuleConfig, false);
    }

    private static void check(ShardingSphereMetaData shardingSphereMetaData, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig, boolean isCreate) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        ShardingTableRuleStatementChecker.checkShardingTables(schemaName, rules, currentRuleConfig, isCreate);
        ShardingTableRuleStatementChecker.checkResources(schemaName, rules, shardingSphereMetaData);
        ShardingTableRuleStatementChecker.checkKeyGenerators(rules, currentRuleConfig);
        Map<String, List<AbstractTableRuleSegment>> groupedTableRule = ShardingTableRuleStatementChecker.groupingByClassType(rules);
        ShardingTableRuleStatementChecker.checkAutoTableRule(groupedTableRule.getOrDefault(AutoTableRuleSegment.class.getSimpleName(), Collections.emptyList()));
        ShardingTableRuleStatementChecker.checkTableRule(schemaName, currentRuleConfig, groupedTableRule.getOrDefault(TableRuleSegment.class.getSimpleName(), Collections.emptyList()));
    }

    private static void checkResources(String schemaName, Collection<AbstractTableRuleSegment> rules, ShardingSphereMetaData shardingSphereMetaData) throws DistSQLException {
        Collection<String> requiredResource = ShardingTableRuleStatementChecker.getRequiredResources(rules);
        Collection notExistedResources = shardingSphereMetaData.getResource().getNotExistedResources(requiredResource);
        Collection<String> logicResources = ShardingTableRuleStatementChecker.getLogicResources(shardingSphereMetaData);
        notExistedResources.removeIf(logicResources::contains);
        DistSQLException.predictionThrow((boolean)notExistedResources.isEmpty(), () -> new RequiredResourceMissedException(schemaName, notExistedResources));
    }

    private static Collection<String> getLogicResources(ShardingSphereMetaData shardingSphereMetaData) {
        return shardingSphereMetaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataSourceContainedRule).map(each -> ((DataSourceContainedRule)each).getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Collection<String> getRequiredResources(Collection<AbstractTableRuleSegment> rules) {
        return rules.stream().map(AbstractTableRuleSegment::getDataSourceNodes).flatMap(Collection::stream).map(ShardingTableRuleStatementChecker::parseDateSource).map(ShardingTableRuleStatementChecker::getDataSourceNames).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Collection<String> parseDateSource(String dateSource) {
        return InlineExpressionParser.isInlineExpression((String)dateSource) ? new InlineExpressionParser(dateSource).splitAndEvaluate() : Collections.singletonList(dateSource);
    }

    private static Collection<String> getDataSourceNames(Collection<String> actualDataNodes) {
        return actualDataNodes.stream().map(each -> {
            if (ShardingTableRuleStatementChecker.isValidDataNode(each)) {
                return actualDataNodes.stream().map(each1 -> new DataNode(each1).getDataSourceName()).collect(Collectors.toList());
            }
            return Collections.singletonList(each);
        }).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isValidDataNode(String dataNodeStr) {
        return dataNodeStr.contains(DELIMITER) && 2 == Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)dataNodeStr).size();
    }

    private static void checkShardingTables(String schemaName, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig, boolean isCreate) throws DistSQLException {
        List<String> currentShardingTables;
        LinkedList requiredShardingTables = rules.stream().map(AbstractTableRuleSegment::getLogicTable).collect(Collectors.toCollection(LinkedList::new));
        Set<String> duplicatedShardingTables = ShardingTableRuleStatementChecker.getDuplicate(requiredShardingTables);
        DistSQLException.predictionThrow((boolean)duplicatedShardingTables.isEmpty(), () -> new DuplicateRuleException("sharding", schemaName, (Collection)duplicatedShardingTables));
        Collection<Object> collection = currentShardingTables = null == currentRuleConfig ? Collections.emptyList() : ShardingTableRuleStatementChecker.getCurrentShardingTables(currentRuleConfig);
        if (isCreate) {
            Set<String> identical = ShardingTableRuleStatementChecker.getIdentical(requiredShardingTables, currentShardingTables);
            DistSQLException.predictionThrow((boolean)identical.isEmpty(), () -> new DuplicateRuleException("sharding", schemaName, (Collection)identical));
        } else {
            Set<String> different = ShardingTableRuleStatementChecker.getDifferent(requiredShardingTables, currentShardingTables);
            DistSQLException.predictionThrow((boolean)different.isEmpty(), () -> new RequiredRuleMissedException("sharding", schemaName, (Collection)different));
        }
    }

    private static Set<String> getDuplicate(Collection<String> collection) {
        return collection.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static Set<String> getIdentical(Collection<String> require, Collection<String> current) {
        return require.stream().filter(current::contains).collect(Collectors.toSet());
    }

    private static Set<String> getDifferent(Collection<String> require, Collection<String> current) {
        return require.stream().filter(each -> !current.contains(each)).collect(Collectors.toSet());
    }

    private static Collection<String> getCurrentShardingTables(ShardingRuleConfiguration currentRuleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private static void checkKeyGenerators(Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        LinkedHashSet notExistKeyGenerator = new LinkedHashSet(rules.size());
        LinkedHashSet requiredKeyGenerators = new LinkedHashSet(rules.size());
        rules.stream().map(AbstractTableRuleSegment::getKeyGenerateStrategySegment).filter(Objects::nonNull).peek(each -> each.getKeyGenerateAlgorithmName().filter(op -> null == currentRuleConfig || !currentRuleConfig.getKeyGenerators().containsKey(op)).ifPresent(notExistKeyGenerator::add)).filter(each -> !each.getKeyGenerateAlgorithmName().isPresent()).forEach(each -> requiredKeyGenerators.add(each.getKeyGenerateAlgorithmSegment().getName()));
        DistSQLException.predictionThrow((boolean)notExistKeyGenerator.isEmpty(), () -> new RequiredAlgorithmMissedException("key generator", (Collection)notExistKeyGenerator));
        Collection invalidKeyGenerators = requiredKeyGenerators.stream().distinct().filter(each -> !TypedSPIRegistry.findRegisteredService(KeyGenerateAlgorithm.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidKeyGenerators.isEmpty(), () -> new InvalidAlgorithmConfigurationException("key generator", invalidKeyGenerators));
    }

    private static void checkAutoTableRule(Collection<AbstractTableRuleSegment> rules) throws DistSQLException {
        Collection autoTableRules = rules.stream().map(each -> (AutoTableRuleSegment)each).collect(Collectors.toCollection(LinkedList::new));
        Optional<AlgorithmSegment> anyAutoTableRule = autoTableRules.stream().map(AutoTableRuleSegment::getShardingAlgorithmSegment).filter(Objects::nonNull).findAny();
        if (anyAutoTableRule.isPresent()) {
            ShardingTableRuleStatementChecker.checkShardingAlgorithms(autoTableRules);
        }
    }

    private static void checkShardingAlgorithms(Collection<AutoTableRuleSegment> rules) throws DistSQLException {
        LinkedList incompleteShardingRules = rules.stream().filter(each -> !each.isCompleteShardingAlgorithm()).collect(Collectors.toCollection(LinkedList::new));
        DistSQLException.predictionThrow((boolean)incompleteShardingRules.isEmpty(), () -> new InvalidAlgorithmConfigurationException("sharding"));
        Collection invalidShardingAlgorithms = rules.stream().map(each -> each.getShardingAlgorithmSegment().getName()).distinct().filter(each -> !TypedSPIRegistry.findRegisteredService(ShardingAlgorithm.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidShardingAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException("sharding", invalidShardingAlgorithms));
    }

    private static void checkTableRule(String schemaName, ShardingRuleConfiguration currentRuleConfig, Collection<AbstractTableRuleSegment> rules) throws DistSQLException {
        Collection tableRules = rules.stream().map(each -> (TableRuleSegment)each).collect(Collectors.toCollection(LinkedList::new));
        Optional<ShardingStrategySegment> anyTableRule = tableRules.stream().map(each -> Arrays.asList(each.getDatabaseStrategySegment(), each.getTableStrategySegment())).flatMap(Collection::stream).filter(Objects::nonNull).findAny();
        if (anyTableRule.isPresent()) {
            ShardingTableRuleStatementChecker.checkStrategy(schemaName, currentRuleConfig, tableRules);
        }
    }

    private static void checkStrategy(String schemaName, ShardingRuleConfiguration currentRuleConfig, Collection<TableRuleSegment> rules) throws DistSQLException {
        Set currentAlgorithms = null == currentRuleConfig ? Collections.emptySet() : currentRuleConfig.getShardingAlgorithms().keySet();
        Collection invalidAlgorithms = rules.stream().map(each -> Arrays.asList(each.getDatabaseStrategySegment(), each.getTableStrategySegment())).flatMap(Collection::stream).filter(Objects::nonNull).filter(each -> ShardingTableRuleStatementChecker.isInvalidStrategy(currentAlgorithms, each)).map(ShardingStrategySegment::getShardingAlgorithmName).collect(Collectors.toCollection(LinkedList::new));
        DistSQLException.predictionThrow((boolean)invalidAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException(schemaName, invalidAlgorithms));
    }

    private static boolean isInvalidStrategy(Collection<String> currentAlgorithms, ShardingStrategySegment shardingStrategySegment) {
        return !ShardingStrategyType.contain(shardingStrategySegment.getType()) || !ShardingStrategyType.getValueOf(shardingStrategySegment.getType()).isValid(shardingStrategySegment.getShardingColumn()) || !ShardingTableRuleStatementChecker.isAlgorithmExists(currentAlgorithms, shardingStrategySegment);
    }

    private static boolean isAlgorithmExists(Collection<String> currentAlgorithms, ShardingStrategySegment shardingStrategySegment) {
        if (null == shardingStrategySegment.getShardingAlgorithmName() && null != shardingStrategySegment.getAlgorithmSegment()) {
            return true;
        }
        return currentAlgorithms.contains(shardingStrategySegment.getShardingAlgorithmName());
    }

    private static Map<String, List<AbstractTableRuleSegment>> groupingByClassType(Collection<AbstractTableRuleSegment> rules) {
        return rules.stream().collect(Collectors.groupingBy(each -> each.getClass().getSimpleName()));
    }
}

