/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlPositionFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.context.ConverterContextHolder;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;

public final class FunctionConverter
implements SQLSegmentConverter<FunctionSegment, SqlBasicCall> {
    @Override
    public Optional<SqlBasicCall> convertToSQLNode(FunctionSegment segment) {
        if ("POSITION".equalsIgnoreCase(segment.getFunctionName())) {
            return Optional.of(new SqlBasicCall((SqlOperator)new SqlPositionFunction(), this.getSqlNodes(segment.getParameters()), SqlParserPos.ZERO));
        }
        if ("CAST".equalsIgnoreCase(segment.getFunctionName())) {
            return Optional.of(new SqlBasicCall((SqlOperator)new SqlCastFunction(), this.getSqlNodes(segment.getParameters()), SqlParserPos.ZERO));
        }
        if ("CONCAT".equalsIgnoreCase(segment.getFunctionName())) {
            return Optional.of(new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(new SqlIdentifier("CONCAT", SqlParserPos.ZERO), null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), this.getSqlNodes(segment.getParameters()), SqlParserPos.ZERO));
        }
        return Optional.empty();
    }

    @Override
    public Optional<FunctionSegment> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        FunctionSegment functionSegment = new FunctionSegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), sqlBasicCall.getOperator().getName(), this.getFunctionText(sqlBasicCall));
        functionSegment.getParameters().addAll(this.getParameters(sqlBasicCall));
        return Optional.of(functionSegment);
    }

    private String getFunctionText(SqlBasicCall sqlBasicCall) {
        SqlOperator operator = sqlBasicCall.getOperator();
        if (null != operator && (operator instanceof SqlCastFunction || operator instanceof SqlUnresolvedFunction)) {
            return sqlBasicCall.toString().replace("`", "");
        }
        return sqlBasicCall.toString();
    }

    private List<ExpressionSegment> getParameters(SqlBasicCall sqlBasicCall) {
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>();
        sqlBasicCall.getOperandList().forEach(each -> {
            if (each instanceof SqlDataTypeSpec) {
                DataTypeSegment dataTypeSegment = new DataTypeSegment();
                dataTypeSegment.setStartIndex(this.getStartIndex((SqlNode)each));
                dataTypeSegment.setStopIndex(this.getStopIndex((SqlNode)each));
                dataTypeSegment.setDataTypeName(each.toString().replace("`", ""));
                result.add((ExpressionSegment)dataTypeSegment);
            } else if (each instanceof SqlCharStringLiteral) {
                result.add((ExpressionSegment)new LiteralExpressionSegment(this.getStartIndex((SqlNode)each), this.getStopIndex((SqlNode)each), (Object)each.toString().replace("'", "")));
            } else if (each instanceof SqlDynamicParam) {
                ConverterContextHolder.get().getParameterCount().getAndIncrement();
                result.add((ExpressionSegment)new ParameterMarkerExpressionSegment(this.getStartIndex((SqlNode)each), this.getStopIndex((SqlNode)each), ((SqlDynamicParam)each).getIndex()));
            }
        });
        return result;
    }

    private SqlNode[] getSqlNodes(Collection<ExpressionSegment> sqlSegments) {
        ArrayList sqlNodes = new ArrayList();
        sqlSegments.forEach(each -> {
            if (each instanceof LiteralExpressionSegment) {
                sqlNodes.add(SqlLiteral.createCharString((String)((LiteralExpressionSegment)each).getLiterals().toString(), (SqlParserPos)SqlParserPos.ZERO));
            }
            if (each instanceof DataTypeSegment) {
                sqlNodes.add(new SqlDataTypeSpec((SqlTypeNameSpec)new SqlUserDefinedTypeNameSpec(((DataTypeSegment)each).getDataTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO));
            }
            if (each instanceof ParameterMarkerExpressionSegment) {
                sqlNodes.add(new SqlDynamicParam(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex(), SqlParserPos.ZERO));
            }
        });
        return sqlNodes.toArray(new SqlNode[0]);
    }
}

