/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropIndexEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementSchemaRefresher
implements MetaDataRefresher<DropIndexStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DropIndexStatement sqlStatement, ConfigurationProperties props) {
        DropIndexEvent event = new DropIndexEvent();
        for (IndexSegment each : sqlStatement.getIndexes()) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
            Optional<String> logicTableName = this.findLogicTableName(database, sqlStatement, Collections.singletonList(each));
            if (!logicTableName.isPresent()) continue;
            ShardingSphereTable table = database.getSchema(actualSchemaName).getTable(logicTableName.get());
            table.getIndexes().remove(each.getIndexName().getIdentifier().getValue());
            event.getSchemaAlteredEvents().add(this.buildSchemaAlteredEvent(database.getName(), actualSchemaName, table));
        }
        return Optional.of(event);
    }

    private Optional<String> findLogicTableName(ShardingSphereDatabase database, DropIndexStatement sqlStatement, Collection<IndexSegment> indexSegments) {
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement);
        if (simpleTableSegment.isPresent()) {
            return Optional.of(((SimpleTableSegment)simpleTableSegment.get()).getTableName().getIdentifier().getValue());
        }
        Collection tableNames = IndexMetaDataUtil.getTableNames((ShardingSphereDatabase)database, (DatabaseType)database.getResourceMetaData().getDatabaseType(), indexSegments);
        return tableNames.isEmpty() ? Optional.empty() : Optional.of(((QualifiedTable)tableNames.iterator().next()).getTableName());
    }

    private SchemaAlteredEvent buildSchemaAlteredEvent(String databaseName, String schemaName, ShardingSphereTable table) {
        SchemaAlteredEvent result = new SchemaAlteredEvent(databaseName, schemaName);
        result.getAlteredTables().add(table);
        return result;
    }

    public String getType() {
        return DropIndexStatement.class.getName();
    }
}

