/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.api.config.encryptor.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.encryptor.EncryptorRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.TableRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.spring.datasource.SpringShardingDataSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ShardingDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringShardingDataSource.class);
        factory.addConstructorArgValue(this.parseDataSources(element));
        factory.addConstructorArgValue((Object)this.parseShardingRuleConfiguration(element));
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseDataSources(Element element) {
        Element shardingRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"sharding-rule");
        List dataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)shardingRuleElement.getAttribute("data-source-names"));
        ManagedMap result = new ManagedMap(dataSources.size());
        for (String each : dataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        return result;
    }

    private BeanDefinition parseShardingRuleConfiguration(Element element) {
        Element shardingRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"sharding-rule");
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingRuleConfiguration.class);
        this.parseDefaultDataSource(factory, shardingRuleElement);
        this.parseDefaultDatabaseShardingStrategy(factory, shardingRuleElement);
        this.parseDefaultTableShardingStrategy(factory, shardingRuleElement);
        factory.addPropertyValue("tableRuleConfigs", this.parseTableRulesConfiguration(shardingRuleElement));
        factory.addPropertyValue("masterSlaveRuleConfigs", this.parseMasterSlaveRulesConfiguration(shardingRuleElement));
        factory.addPropertyValue("bindingTableGroups", this.parseBindingTablesConfiguration(shardingRuleElement));
        factory.addPropertyValue("broadcastTables", this.parseBroadcastTables(shardingRuleElement));
        this.parseDefaultKeyGenerator(factory, shardingRuleElement);
        this.parseEncryptRuleConfiguration(factory, shardingRuleElement);
        return factory.getBeanDefinition();
    }

    private void parseDefaultKeyGenerator(BeanDefinitionBuilder factory, Element element) {
        String defaultKeyGeneratorConfig = element.getAttribute("default-key-generator-ref");
        if (!Strings.isNullOrEmpty((String)defaultKeyGeneratorConfig)) {
            factory.addPropertyReference("defaultKeyGeneratorConfig", defaultKeyGeneratorConfig);
        }
    }

    private void parseDefaultDataSource(BeanDefinitionBuilder factory, Element element) {
        String defaultDataSource = element.getAttribute("default-data-source-name");
        if (!Strings.isNullOrEmpty((String)defaultDataSource)) {
            factory.addPropertyValue("defaultDataSourceName", (Object)defaultDataSource);
        }
    }

    private void parseDefaultDatabaseShardingStrategy(BeanDefinitionBuilder factory, Element element) {
        String defaultDatabaseShardingStrategy = element.getAttribute("default-database-strategy-ref");
        if (!Strings.isNullOrEmpty((String)defaultDatabaseShardingStrategy)) {
            factory.addPropertyReference("defaultDatabaseShardingStrategyConfig", defaultDatabaseShardingStrategy);
        }
    }

    private void parseDefaultTableShardingStrategy(BeanDefinitionBuilder factory, Element element) {
        String defaultTableShardingStrategy = element.getAttribute("default-table-strategy-ref");
        if (!Strings.isNullOrEmpty((String)defaultTableShardingStrategy)) {
            factory.addPropertyReference("defaultTableShardingStrategyConfig", defaultTableShardingStrategy);
        }
    }

    private List<BeanDefinition> parseMasterSlaveRulesConfiguration(Element element) {
        Element masterSlaveRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"master-slave-rules");
        if (null == masterSlaveRulesElement) {
            return new LinkedList<BeanDefinition>();
        }
        List masterSlaveRuleElements = DomUtils.getChildElementsByTagName((Element)masterSlaveRulesElement, (String)"master-slave-rule");
        ManagedList result = new ManagedList(masterSlaveRuleElements.size());
        for (Element each : masterSlaveRuleElements) {
            result.add(this.parseMasterSlaveRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseMasterSlaveRuleConfiguration(Element masterSlaveElement) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(MasterSlaveRuleConfiguration.class);
        factory.addConstructorArgValue((Object)masterSlaveElement.getAttribute("id"));
        factory.addConstructorArgValue((Object)masterSlaveElement.getAttribute("master-data-source-name"));
        factory.addConstructorArgValue(this.parseSlaveDataSourcesRef(masterSlaveElement));
        this.parseMasterSlaveRuleLoadBalanceAlgorithm(masterSlaveElement, factory);
        return factory.getBeanDefinition();
    }

    private void parseMasterSlaveRuleLoadBalanceAlgorithm(Element masterSlaveElement, BeanDefinitionBuilder factory) {
    }

    private Collection<String> parseSlaveDataSourcesRef(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedList result = new ManagedList(slaveDataSources.size());
        result.addAll(slaveDataSources);
        return result;
    }

    private void parseEncryptRuleConfiguration(BeanDefinitionBuilder factory, Element element) {
        Element encryptRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"encrypt-rules");
        if (null != encryptRuleElement) {
            factory.addPropertyValue("encryptRuleConfig", (Object)this.parseEncryptRuleConfiguration(encryptRuleElement));
        }
    }

    private BeanDefinition parseEncryptRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptRuleConfiguration.class);
        factory.addConstructorArgValue(this.parseEncryptorRulesConfiguration(element));
        return factory.getBeanDefinition();
    }

    private Map<String, BeanDefinition> parseEncryptorRulesConfiguration(Element element) {
        List encryptorRuleElements = DomUtils.getChildElementsByTagName((Element)element, (String)"encryptor-rule");
        ManagedMap result = new ManagedMap(encryptorRuleElements.size());
        for (Element each : encryptorRuleElements) {
            result.put(each.getAttribute("id"), this.parseEncryptorRuleConfiguration(each));
        }
        return result;
    }

    private AbstractBeanDefinition parseEncryptorRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptorRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("type"));
        factory.addConstructorArgValue((Object)element.getAttribute("qualified-columns"));
        this.parseAssistedQueryColumns(element, factory);
        this.parseProperties(element, factory);
        return factory.getBeanDefinition();
    }

    private void parseAssistedQueryColumns(Element element, BeanDefinitionBuilder factory) {
        String assistedQueryColumns = element.getAttribute("assisted-query-columns");
        if (!Strings.isNullOrEmpty((String)assistedQueryColumns)) {
            factory.addConstructorArgValue((Object)assistedQueryColumns);
        }
    }

    private void parseProperties(Element element, BeanDefinitionBuilder factory) {
        String properties = element.getAttribute("props-ref");
        if (!Strings.isNullOrEmpty((String)properties)) {
            factory.addConstructorArgReference(properties);
        } else {
            factory.addConstructorArgValue((Object)new Properties());
        }
    }

    private List<BeanDefinition> parseTableRulesConfiguration(Element element) {
        Element tableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"table-rules");
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)tableRulesElement, (String)"table-rule");
        ManagedList result = new ManagedList(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.add(this.parseTableRuleConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseTableRuleConfiguration(Element tableElement) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(TableRuleConfiguration.class);
        factory.addConstructorArgValue((Object)tableElement.getAttribute("logic-table"));
        this.parseActualDataNodes(tableElement, factory);
        this.parseDatabaseShardingStrategyConfiguration(tableElement, factory);
        this.parseTableShardingStrategyConfiguration(tableElement, factory);
        this.parseKeyGeneratorConfiguration(tableElement, factory);
        this.parseLogicIndex(tableElement, factory);
        return factory.getBeanDefinition();
    }

    private void parseActualDataNodes(Element tableElement, BeanDefinitionBuilder factory) {
        String actualDataNodes = tableElement.getAttribute("actual-data-nodes");
        if (!Strings.isNullOrEmpty((String)actualDataNodes)) {
            factory.addConstructorArgValue((Object)actualDataNodes);
        }
    }

    private void parseDatabaseShardingStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String databaseStrategy = tableElement.getAttribute("database-strategy-ref");
        if (!Strings.isNullOrEmpty((String)databaseStrategy)) {
            factory.addPropertyReference("databaseShardingStrategyConfig", databaseStrategy);
        }
    }

    private void parseTableShardingStrategyConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String tableStrategy = tableElement.getAttribute("table-strategy-ref");
        if (!Strings.isNullOrEmpty((String)tableStrategy)) {
            factory.addPropertyReference("tableShardingStrategyConfig", tableStrategy);
        }
    }

    private void parseKeyGeneratorConfiguration(Element tableElement, BeanDefinitionBuilder factory) {
        String keyGenerator = tableElement.getAttribute("key-generator-ref");
        if (!Strings.isNullOrEmpty((String)keyGenerator)) {
            factory.addPropertyReference("keyGeneratorConfig", keyGenerator);
        }
    }

    private void parseLogicIndex(Element tableElement, BeanDefinitionBuilder factory) {
        String logicIndex = tableElement.getAttribute("logic-index");
        if (!Strings.isNullOrEmpty((String)logicIndex)) {
            factory.addPropertyValue("logicIndex", (Object)logicIndex);
        }
    }

    private List<String> parseBindingTablesConfiguration(Element element) {
        Element bindingTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"binding-table-rules");
        if (null == bindingTableRulesElement) {
            return Collections.emptyList();
        }
        List bindingTableRuleElements = DomUtils.getChildElementsByTagName((Element)bindingTableRulesElement, (String)"binding-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : bindingTableRuleElements) {
            result.add(each.getAttribute("logic-tables"));
        }
        return result;
    }

    private List<String> parseBroadcastTables(Element element) {
        Element broadcastTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"broadcast-table-rules");
        if (null == broadcastTableRulesElement) {
            return Collections.emptyList();
        }
        List broadcastTableRuleElements = DomUtils.getChildElementsByTagName((Element)broadcastTableRulesElement, (String)"broadcast-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : broadcastTableRuleElements) {
            result.add(each.getAttribute("table"));
        }
        return result;
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

