/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.trace.AsyncTraceDispatcher;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.hook.SendMessageTraceHookImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionListener;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RocketMQUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMQUtil.class);

    public static TransactionListener convert(final RocketMQLocalTransactionListener listener) {
        return new TransactionListener(){

            public LocalTransactionState executeLocalTransaction(Message message, Object obj) {
                RocketMQLocalTransactionState state = listener.executeLocalTransaction(RocketMQUtil.convertToSpringMessage(message), obj);
                return RocketMQUtil.convertLocalTransactionState(state);
            }

            public LocalTransactionState checkLocalTransaction(MessageExt messageExt) {
                RocketMQLocalTransactionState state = listener.checkLocalTransaction(RocketMQUtil.convertToSpringMessage(messageExt));
                return RocketMQUtil.convertLocalTransactionState(state);
            }
        };
    }

    private static LocalTransactionState convertLocalTransactionState(RocketMQLocalTransactionState state) {
        switch (state) {
            case UNKNOWN: {
                return LocalTransactionState.UNKNOW;
            }
            case COMMIT: {
                return LocalTransactionState.COMMIT_MESSAGE;
            }
            case ROLLBACK: {
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
        }
        log.warn("Failed to covert enum type RocketMQLocalTransactionState {}.", (Object)state);
        return LocalTransactionState.UNKNOW;
    }

    public static MessagingException convert(MQClientException e) {
        return new MessagingException(e.getErrorMessage(), (Throwable)e);
    }

    public static org.springframework.messaging.Message convertToSpringMessage(MessageExt message) {
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message.getBody()).setHeader(RocketMQUtil.toRocketHeaderKey("KEYS"), (Object)message.getKeys()).setHeader(RocketMQUtil.toRocketHeaderKey("TAGS"), (Object)message.getTags()).setHeader(RocketMQUtil.toRocketHeaderKey("TOPIC"), (Object)message.getTopic()).setHeader(RocketMQUtil.toRocketHeaderKey("MESSAGE_ID"), (Object)message.getMsgId()).setHeader(RocketMQUtil.toRocketHeaderKey("BORN_TIMESTAMP"), (Object)message.getBornTimestamp()).setHeader(RocketMQUtil.toRocketHeaderKey("BORN_HOST"), (Object)message.getBornHostString()).setHeader(RocketMQUtil.toRocketHeaderKey("FLAG"), (Object)message.getFlag()).setHeader(RocketMQUtil.toRocketHeaderKey("QUEUE_ID"), (Object)message.getQueueId()).setHeader(RocketMQUtil.toRocketHeaderKey("SYS_FLAG"), (Object)message.getSysFlag()).setHeader(RocketMQUtil.toRocketHeaderKey("TRANSACTION_ID"), (Object)message.getTransactionId());
        RocketMQUtil.addUserProperties(message.getProperties(), messageBuilder);
        return messageBuilder.build();
    }

    public static String toRocketHeaderKey(String rawKey) {
        return "rocketmq_" + rawKey;
    }

    private static void addUserProperties(Map<String, String> properties, MessageBuilder messageBuilder) {
        if (!CollectionUtils.isEmpty(properties)) {
            properties.forEach((key, val) -> {
                if (!(MessageConst.STRING_HASH_SET.contains(key) || "id".equals(key) || "timestamp".equals(key) || key.startsWith("rocketmq_") && MessageConst.STRING_HASH_SET.contains(key.replaceFirst("^rocketmq_", "")))) {
                    messageBuilder.setHeader(key, val);
                }
            });
        }
    }

    public static org.springframework.messaging.Message convertToSpringMessage(Message message) {
        MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)message.getBody()).setHeader(RocketMQUtil.toRocketHeaderKey("KEYS"), (Object)message.getKeys()).setHeader(RocketMQUtil.toRocketHeaderKey("TAGS"), (Object)message.getTags()).setHeader(RocketMQUtil.toRocketHeaderKey("TOPIC"), (Object)message.getTopic()).setHeader(RocketMQUtil.toRocketHeaderKey("FLAG"), (Object)message.getFlag()).setHeader(RocketMQUtil.toRocketHeaderKey("TRANSACTION_ID"), (Object)message.getTransactionId());
        RocketMQUtil.addUserProperties(message.getProperties(), messageBuilder);
        return messageBuilder.build();
    }

    @Deprecated
    public static Message convertToRocketMessage(ObjectMapper objectMapper, String charset, String destination, org.springframework.messaging.Message message) {
        byte[] payloads;
        Object payloadObj = message.getPayload();
        if (payloadObj instanceof String) {
            payloads = ((String)payloadObj).getBytes(Charset.forName(charset));
        } else if (payloadObj instanceof byte[]) {
            payloads = (byte[])message.getPayload();
        } else {
            try {
                String jsonObj = objectMapper.writeValueAsString(payloadObj);
                payloads = jsonObj.getBytes(Charset.forName(charset));
            }
            catch (Exception e) {
                throw new RuntimeException("convert to RocketMQ message failed.", e);
            }
        }
        return RocketMQUtil.getAndWrapMessage(destination, message.getHeaders(), payloads);
    }

    private static Message getAndWrapMessage(String destination, MessageHeaders headers, byte[] payloads) {
        if (destination == null || destination.length() < 1) {
            return null;
        }
        if (payloads == null || payloads.length < 1) {
            return null;
        }
        String[] tempArr = destination.split(":", 2);
        String topic = tempArr[0];
        String tags = "";
        if (tempArr.length > 1) {
            tags = tempArr[1];
        }
        Message rocketMsg = new Message(topic, tags, payloads);
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            int flag;
            block8: {
                Object keys = headers.get((Object)"KEYS");
                if (StringUtils.isEmpty((Object)keys)) {
                    keys = headers.get((Object)RocketMQUtil.toRocketHeaderKey("KEYS"));
                }
                if (!StringUtils.isEmpty((Object)keys)) {
                    rocketMsg.setKeys(keys.toString());
                }
                Object flagObj = headers.getOrDefault((Object)"FLAG", (Object)"0");
                flag = 0;
                try {
                    flag = Integer.parseInt(flagObj.toString());
                }
                catch (NumberFormatException e) {
                    if (!log.isInfoEnabled()) break block8;
                    log.info("flag must be integer, flagObj:{}", flagObj);
                }
            }
            rocketMsg.setFlag(flag);
            Object waitStoreMsgOkObj = headers.getOrDefault((Object)"WAIT_STORE_MSG_OK", (Object)"true");
            rocketMsg.setWaitStoreMsgOK(Boolean.TRUE.equals(waitStoreMsgOkObj));
            headers.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "FLAG") && !Objects.equals(entry.getKey(), "WAIT_STORE_MSG_OK")).forEach(entry -> {
                if (!MessageConst.STRING_HASH_SET.contains(entry.getKey())) {
                    rocketMsg.putUserProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            });
        }
        return rocketMsg;
    }

    public static Message convertToRocketMessage(MessageConverter messageConverter, String charset, String destination, org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        Object payloadObj = message.getPayload();
        try {
            if (null == payloadObj) {
                throw new RuntimeException("the message cannot be empty");
            }
            if (payloadObj instanceof String) {
                payloads = ((String)payloadObj).getBytes(Charset.forName(charset));
            } else if (payloadObj instanceof byte[]) {
                payloads = (byte[])message.getPayload();
            } else {
                String jsonObj = (String)messageConverter.fromMessage(message, payloadObj.getClass());
                if (null == jsonObj) {
                    throw new RuntimeException(String.format("empty after conversion [messageConverter:%s,payloadClass:%s,payloadObj:%s]", messageConverter.getClass(), payloadObj.getClass(), payloadObj));
                }
                payloads = jsonObj.getBytes(Charset.forName(charset));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("convert to RocketMQ message failed.", e);
        }
        return RocketMQUtil.getAndWrapMessage(destination, message.getHeaders(), payloads);
    }

    public static RPCHook getRPCHookByAkSk(Environment env, String accessKeyOrExpr, String secretKeyOrExpr) {
        String sk;
        String ak;
        try {
            ak = env.resolveRequiredPlaceholders(accessKeyOrExpr);
            sk = env.resolveRequiredPlaceholders(secretKeyOrExpr);
        }
        catch (Exception e) {
            ak = null;
            sk = null;
        }
        if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
            return new AclClientRPCHook(new SessionCredentials(ak, sk));
        }
        return null;
    }

    public static DefaultMQProducer createDefaultMQProducer(String groupName, String ak, String sk, boolean isEnableMsgTrace, String customizedTraceTopic) {
        TransactionMQProducer producer;
        boolean isEnableAcl;
        boolean bl = isEnableAcl = !StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk);
        if (isEnableAcl) {
            producer = new TransactionMQProducer(groupName, (RPCHook)new AclClientRPCHook(new SessionCredentials(ak, sk)));
            producer.setVipChannelEnabled(false);
        } else {
            producer = new TransactionMQProducer(groupName);
        }
        if (isEnableMsgTrace) {
            try {
                AsyncTraceDispatcher dispatcher = new AsyncTraceDispatcher(groupName, TraceDispatcher.Type.PRODUCE, customizedTraceTopic, (RPCHook)(isEnableAcl ? new AclClientRPCHook(new SessionCredentials(ak, sk)) : null));
                dispatcher.setHostProducer(producer.getDefaultMQProducerImpl());
                Field field = DefaultMQProducer.class.getDeclaredField("traceDispatcher");
                field.setAccessible(true);
                field.set(producer, dispatcher);
                producer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new SendMessageTraceHookImpl((TraceDispatcher)dispatcher));
            }
            catch (Throwable e) {
                log.error("system trace hook init failed ,maybe can't send msg trace data");
            }
        }
        return producer;
    }

    public static String getInstanceName(String identify) {
        char separator = '@';
        StringBuilder instanceName = new StringBuilder();
        instanceName.append(identify).append(separator).append(UtilAll.getPid()).append(separator).append(System.nanoTime());
        return instanceName.toString();
    }

    public static DefaultLitePullConsumer createDefaultLitePullConsumer(String nameServer, String accessChannel, String groupName, String topicName, MessageModel messageModel, SelectorType selectorType, String selectorExpression, String ak, String sk, int pullBatchSize) throws MQClientException {
        DefaultLitePullConsumer litePullConsumer = null;
        if (!StringUtils.isEmpty((Object)ak) && !StringUtils.isEmpty((Object)sk)) {
            litePullConsumer = new DefaultLitePullConsumer(groupName, (RPCHook)new AclClientRPCHook(new SessionCredentials(ak, sk)));
            litePullConsumer.setVipChannelEnabled(false);
        } else {
            litePullConsumer = new DefaultLitePullConsumer(groupName);
        }
        litePullConsumer.setNamesrvAddr(nameServer);
        litePullConsumer.setInstanceName(RocketMQUtil.getInstanceName(nameServer));
        litePullConsumer.setPullBatchSize(pullBatchSize);
        if (accessChannel != null) {
            litePullConsumer.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        switch (messageModel) {
            case BROADCASTING: {
                litePullConsumer.setMessageModel(org.apache.rocketmq.common.protocol.heartbeat.MessageModel.BROADCASTING);
                break;
            }
            case CLUSTERING: {
                litePullConsumer.setMessageModel(org.apache.rocketmq.common.protocol.heartbeat.MessageModel.CLUSTERING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'messageModel' was wrong.");
            }
        }
        switch (selectorType) {
            case SQL92: {
                litePullConsumer.subscribe(topicName, MessageSelector.bySql((String)selectorExpression));
                break;
            }
            case TAG: {
                litePullConsumer.subscribe(topicName, selectorExpression);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'selectorType' was wrong.");
            }
        }
        return litePullConsumer;
    }
}

