/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.unedit;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.unedit.AbstractUnEditCommand;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.unedit.ClearCaseUnEditConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseUnEditCommand
extends AbstractUnEditCommand
implements ClearCaseCommand {
    protected ScmResult executeUnEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing unedit command...");
        Commandline cl = ClearCaseUnEditCommand.createCommandLine(this.getLogger(), fileSet);
        ClearCaseUnEditConsumer consumer = new ClearCaseUnEditConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new StatusScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new StatusScmResult(cl.toString(), consumer.getUnEditFiles());
    }

    public static Commandline createCommandLine(ScmLogger logger, ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("unco");
        command.createArgument().setValue("-keep");
        File[] files = scmFileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            command.createArgument().setValue(file.getName());
        }
        return command;
    }
}

